/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.midi.model;

import java.util.Objects;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.NoteWithPanning;
import net.raphimc.noteblocklib.model.NoteWithVolume;
import net.raphimc.noteblocklib.util.Instrument;

public class MidiNote
extends Note
implements NoteWithVolume,
NoteWithPanning {
    private final long midiTick;
    private byte velocity;
    private byte panning;

    public MidiNote(long midiTick, Instrument instrument, byte key, byte velocity, byte panning) {
        super(instrument, key);
        this.midiTick = midiTick;
        this.velocity = velocity;
        this.panning = panning;
    }

    public long getMidiTick() {
        return this.midiTick;
    }

    @Override
    public float getVolume() {
        return (float)this.velocity / 127.0f * 100.0f;
    }

    @Override
    public void setVolume(float volume) {
        this.velocity = (byte)(volume / 100.0f * 127.0f);
    }

    public byte getRawVelocity() {
        return this.velocity;
    }

    @Override
    public float getPanning() {
        return (float)(this.panning - 64) / 64.0f * 100.0f;
    }

    @Override
    public void setPanning(float panning) {
        this.panning = (byte)(panning / 100.0f * 64.0f + 64.0f);
    }

    public byte getRawPanning() {
        return this.panning;
    }

    @Override
    public MidiNote clone() {
        return new MidiNote(this.midiTick, this.instrument, this.key, this.velocity, this.panning);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MidiNote midiNote = (MidiNote)o;
        return this.velocity == midiNote.velocity && this.panning == midiNote.panning;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.velocity, this.panning);
    }
}

