/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.nbs.model;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import java.io.IOException;
import java.util.Objects;
import net.raphimc.noteblocklib.format.nbs.model.NbsCustomInstrument;
import net.raphimc.noteblocklib.format.nbs.model.NbsData;
import net.raphimc.noteblocklib.format.nbs.model.NbsHeader;
import net.raphimc.noteblocklib.format.nbs.model.NbsLayer;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.NoteWithPanning;
import net.raphimc.noteblocklib.model.NoteWithVolume;
import net.raphimc.noteblocklib.util.Instrument;

public class NbsNote
extends Note
implements NoteWithVolume,
NoteWithPanning {
    private NbsLayer layer;
    private NbsCustomInstrument customInstrument;
    private byte velocity = (byte)100;
    private short panning = (short)100;
    private short pitch = 0;
    private int rawInstrumentId;

    public NbsNote(NbsHeader header, NbsLayer layer, LittleEndianDataInputStream dis) throws IOException {
        super(null, (byte)0);
        this.rawInstrumentId = dis.readUnsignedByte();
        if (this.rawInstrumentId < header.getVanillaInstrumentCount()) {
            this.instrument = Instrument.fromNbsId((byte)this.rawInstrumentId);
        }
        this.key = dis.readByte();
        if (header.getVersion() >= 4) {
            this.velocity = dis.readByte();
            this.panning = (short)dis.readUnsignedByte();
            this.pitch = dis.readShort();
        }
        this.layer = layer;
    }

    public NbsNote(NbsLayer layer, Instrument instrument, byte key, byte velocity, short panning, short pitch, NbsCustomInstrument customInstrument) {
        this(layer, instrument, key, velocity, panning, pitch);
        if (instrument != null && customInstrument != null) {
            throw new IllegalArgumentException("Cannot set both instrument and custom instrument");
        }
        this.customInstrument = customInstrument;
    }

    public NbsNote(NbsLayer layer, Instrument instrument, byte key, byte velocity, short panning, short pitch) {
        this(layer, instrument, key);
        this.velocity = velocity;
        this.panning = panning;
        this.pitch = pitch;
    }

    public NbsNote(NbsLayer layer, Instrument instrument, byte key) {
        super(instrument, key);
        this.layer = layer;
    }

    public NbsNote(Instrument instrument, byte key) {
        super(instrument, key);
    }

    public void write(NbsHeader header, NbsData data, LittleEndianDataOutputStream dos) throws IOException {
        if (this.customInstrument != null) {
            if (!data.getCustomInstruments().contains(this.customInstrument)) {
                throw new IllegalArgumentException("Custom instrument not found in NBS data custom instruments list");
            }
            dos.writeByte((int)((byte)(header.getVanillaInstrumentCount() + data.getCustomInstruments().indexOf(this.customInstrument))));
        } else {
            dos.writeByte((int)this.instrument.nbsId());
        }
        dos.writeByte((int)this.key);
        if (header.getVersion() >= 4) {
            dos.writeByte((int)this.velocity);
            dos.writeByte((int)this.panning);
            dos.writeShort((int)this.pitch);
        }
    }

    void resolveCustomInstrument(NbsHeader header, NbsData data) {
        if (this.rawInstrumentId >= header.getVanillaInstrumentCount()) {
            this.customInstrument = data.getCustomInstruments().get(this.rawInstrumentId - header.getVanillaInstrumentCount());
        }
    }

    @Override
    public void setInstrument(Instrument instrument) {
        super.setInstrument(instrument);
        this.customInstrument = null;
    }

    public NbsLayer getLayer() {
        return this.layer;
    }

    public void setLayer(NbsLayer layer) {
        this.layer = layer;
    }

    public NbsCustomInstrument getCustomInstrument() {
        return this.customInstrument;
    }

    public void setCustomInstrument(NbsCustomInstrument customInstrument) {
        this.customInstrument = customInstrument;
        this.instrument = null;
    }

    @Override
    public float getVolume() {
        float layerVolume = this.layer != null ? (float)this.layer.getVolume() : 100.0f;
        float noteVolume = this.velocity;
        return layerVolume * noteVolume / 100.0f;
    }

    @Override
    public void setVolume(float volume) {
        this.velocity = (byte)volume;
    }

    public byte getRawVelocity() {
        return this.velocity;
    }

    @Override
    public float getPanning() {
        float layerPanning = this.layer != null ? (float)(this.layer.getPanning() - 100) : 0.0f;
        float notePanning = this.panning - 100;
        return (layerPanning + notePanning) / 2.0f;
    }

    @Override
    public void setPanning(float panning) {
        this.panning = (short)(panning + 100.0f);
    }

    public short getRawPanning() {
        return this.panning;
    }

    public short getPitch() {
        return this.pitch;
    }

    public void setPitch(short pitch) {
        this.pitch = pitch;
    }

    @Override
    public NbsNote clone() {
        return new NbsNote(this.layer, this.instrument, this.key, this.velocity, this.panning, this.pitch, this.customInstrument);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NbsNote nbsNote = (NbsNote)o;
        return this.velocity == nbsNote.velocity && this.panning == nbsNote.panning && this.pitch == nbsNote.pitch && Objects.equals(this.customInstrument, nbsNote.customInstrument);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.customInstrument, this.velocity, this.panning, this.pitch);
    }
}

