/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa.query;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.syntax.TemplateGroup;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.rootdev.javardfa.StatementSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryCollector
implements StatementSink {
    static final Logger log = LoggerFactory.getLogger(QueryCollector.class);
    private static final Node FormType = Node.createURI((String)"http://www.w3.org/1999/xhtml/vocab/#form");
    private static final TypeMapper TMapper = TypeMapper.getInstance();
    private final Map<String, Query> queries = new HashMap<String, Query>();
    private List<Triple> currentQuery;
    private String currentQueryName;
    private final Map<String, String> prefixMapping = new HashMap<String, String>();

    public Map<String, Query> getQueries() {
        return Collections.unmodifiableMap(this.queries);
    }

    @Override
    public void addLiteral(String arg0, String arg1, String arg2, String arg3, String arg4) {
        Node subject = this.getNode(arg0);
        Node predicate = this.getNode(arg1);
        Node object = this.getLiteralNode(arg2, arg3, arg4);
        this.addTriple(subject, predicate, object);
    }

    @Override
    public void addObject(String arg0, String arg1, String arg2) {
        Node subject = this.getNode(arg0);
        Node predicate = this.getNode(arg1);
        Node object = this.getNode(arg2);
        this.addTriple(subject, predicate, object);
    }

    private void addTriple(Node subject, Node predicate, Node object) {
        if (RDF.type.asNode().equals((Object)predicate) && FormType.equals((Object)object)) {
            if (this.currentQueryName != null) {
                this.queries.put(this.currentQueryName, this.createQuery(this.currentQuery));
            }
            this.currentQueryName = subject.getURI();
            this.currentQuery = new LinkedList<Triple>();
            return;
        }
        if (this.currentQueryName == null) {
            return;
        }
        this.currentQuery.add(Triple.create((Node)subject, (Node)predicate, (Node)object));
    }

    private Node getLiteralNode(String arg2, String arg3, String arg4) {
        if (arg3 == null && arg4 == null) {
            return Node.createLiteral((String)arg2);
        }
        if (arg4 == null) {
            return Node.createLiteral((String)arg2, (String)arg3, (boolean)false);
        }
        return Node.createLiteral((String)arg2, null, (RDFDatatype)TMapper.getSafeTypeByName(arg4));
    }

    private Node getNode(String arg0) {
        if (arg0.startsWith("_:")) {
            return Node.createAnon((AnonId)AnonId.create((String)arg0.substring(2)));
        }
        if (arg0.startsWith("?")) {
            return Var.alloc((String)arg0.substring(1));
        }
        return Node.createURI((String)arg0);
    }

    @Override
    public void end() {
        if (this.currentQueryName != null) {
            this.queries.put(this.currentQueryName, this.createQuery(this.currentQuery));
        }
    }

    @Override
    public void start() {
    }

    public Query createQuery(List<Triple> triples) {
        log.info("Create query");
        Query query = new Query();
        ElementGroup body = new ElementGroup();
        for (Triple t : triples) {
            body.addTriplePattern(t);
        }
        ElementNamedGraph pattern = new ElementNamedGraph((Node)Var.alloc((String)"graph"), (Element)body);
        query.setQueryPattern((Element)pattern);
        query.addProjectVars(Collections.singleton("s"));
        TemplateGroup templ = new TemplateGroup();
        for (Triple triple : triples) {
            templ.addTriple(triple);
        }
        query.setQuerySelectType();
        query.setQueryResultStar(true);
        query.setConstructTemplate((Template)templ);
        for (Map.Entry entry : this.prefixMapping.entrySet()) {
            query.setPrefix((String)entry.getKey(), (String)entry.getValue());
        }
        return query;
    }

    @Override
    public void addPrefix(String prefix, String uri) {
        this.prefixMapping.put(prefix, uri);
    }

    @Override
    public void setBase(String base) {
    }
}

