/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaocr.demos.android.utils.camera;

import android.hardware.Camera;
import android.util.Log;
import android.view.SurfaceHolder;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CameraManager
implements Camera.AutoFocusCallback,
Camera.PreviewCallback {
    private static final String LOG_TAG = "camera_manager";
    Camera camera;
    boolean cameraActive = false;
    boolean previewActive = false;
    private Camera.Size previewSize;
    public static final int MIN_PREVIEW_WIDTH = 480;
    boolean focusState;
    boolean waitingForFocus = false;
    boolean waitingForPreview = false;
    byte[] previewImage = null;

    public Camera.Size getPreviewSize() {
        return this.previewSize;
    }

    public synchronized void start(SurfaceHolder holder) throws IOException {
        Log.d((String)LOG_TAG, (String)" starting requested ");
        if (!this.cameraActive) {
            Log.d((String)LOG_TAG, (String)" starting");
            this.camera = Camera.open();
            this.startPreview(holder);
            this.cameraActive = true;
            this.waitingForFocus = false;
            this.waitingForPreview = false;
            Log.d((String)LOG_TAG, (String)" started");
        }
    }

    public synchronized void stop() {
        if (this.cameraActive) {
            if (this.camera != null) {
                this.stopPreview();
                this.camera.release();
                this.camera = null;
            }
            this.cameraActive = false;
        }
    }

    private void startPreview(SurfaceHolder holder) throws IOException {
        if (!this.previewActive) {
            Log.d((String)LOG_TAG, (String)" starting preview ");
            Camera.Parameters cameraParameters = this.camera.getParameters();
            Log.d((String)LOG_TAG, (String)("flash modes:" + cameraParameters.getSupportedFlashModes()));
            Log.d((String)LOG_TAG, (String)("autofocus:" + cameraParameters.getSupportedFocusModes()));
            Log.d((String)LOG_TAG, (String)("preview formats:" + cameraParameters.getSupportedPreviewFormats()));
            Log.d((String)LOG_TAG, (String)("scene modes:" + cameraParameters.getSupportedSceneModes()));
            Log.d((String)LOG_TAG, (String)("white balance modes:" + cameraParameters.getSupportedWhiteBalance()));
            this.camera.setPreviewDisplay(holder);
            this.previewSize = cameraParameters.getPreviewSize();
            if (this.previewSize.width <= 480) {
                Log.d((String)LOG_TAG, (String)("preview size is too small:" + this.previewSize.width + "x" + this.previewSize.height));
                List sizes = cameraParameters.getSupportedPreviewSizes();
                Collections.sort(sizes, new Comparator<Camera.Size>(){

                    @Override
                    public int compare(Camera.Size o1, Camera.Size o2) {
                        return new Integer(o2.width).compareTo(o1.width);
                    }
                });
                for (Camera.Size size : sizes) {
                    cameraParameters.setPreviewSize(size.width, size.height);
                    this.camera.setParameters(cameraParameters);
                    Log.d((String)LOG_TAG, (String)("attempt preview size:" + size.width + "x" + size.height));
                    try {
                        this.camera.startPreview();
                        Log.d((String)LOG_TAG, (String)"...accepted - go along");
                        cameraParameters = this.camera.getParameters();
                        break;
                    }
                    catch (RuntimeException rx) {
                        Log.d((String)LOG_TAG, (String)"...barfed, try next");
                    }
                }
            } else {
                Log.d((String)LOG_TAG, (String)(" accepted default preview size on the spot:" + this.previewSize.width + "x" + this.previewSize.height));
                this.camera.startPreview();
            }
            this.previewSize = cameraParameters.getPreviewSize();
            this.previewActive = true;
        }
    }

    private void stopPreview() {
        if (this.previewActive) {
            this.camera.stopPreview();
            this.previewActive = false;
            this.previewSize = null;
        }
    }

    public Camera getCamera() {
        return this.camera;
    }

    public boolean isCameraActive() {
        return this.cameraActive;
    }

    public synchronized boolean doAutofocus() {
        Log.d((String)LOG_TAG, (String)"autofocus requested");
        if (!this.isCameraActive()) {
            return false;
        }
        if (this.waitingForFocus) {
            return false;
        }
        this.focusState = false;
        this.camera.autoFocus((Camera.AutoFocusCallback)this);
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            this.focusState = false;
        }
        this.waitingForFocus = false;
        Log.d((String)LOG_TAG, (String)"autofocus ready");
        return this.focusState;
    }

    public synchronized byte[] getPreviewFrame() {
        Log.d((String)LOG_TAG, (String)"preview frame requested");
        if (!this.isCameraActive()) {
            return null;
        }
        if (this.waitingForPreview) {
            return null;
        }
        this.waitingForPreview = true;
        this.previewImage = null;
        this.camera.setOneShotPreviewCallback((Camera.PreviewCallback)this);
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            this.previewImage = null;
            return null;
        }
        this.waitingForPreview = false;
        return this.previewImage;
    }

    public synchronized void onAutoFocus(boolean b, Camera camera) {
        Log.d((String)LOG_TAG, (String)"autofocus callback received");
        this.focusState = b;
        this.notify();
    }

    public synchronized void onPreviewFrame(byte[] bytes, Camera camera) {
        Log.d((String)LOG_TAG, (String)"preview frame received");
        this.previewImage = bytes;
        this.notify();
    }
}

