/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaocr.demos.android.utils.image;

import java.util.ArrayList;
import java.util.List;
import net.sf.javaocr.demos.android.utils.image.ImageSlicer;
import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.filter.IntegralImageFilter;
import net.sourceforge.javaocr.ocr.PixelImage;
import net.sourceforge.javaocr.ocr.Shrinker;
import net.sourceforge.javaocr.ocr.SlicerH;
import net.sourceforge.javaocr.ocr.SlicerV;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegralImageSlicer
implements ImageSlicer {
    public static final int EMPTY_PIXEL = 0;
    IntegralImageFilter integrator;
    private final Shrinker shrinker;
    private Image integrated;

    public IntegralImageSlicer(int w, int h) {
        this((Image)new PixelImage(w, h));
    }

    public IntegralImageSlicer(Image template) {
        this.integrated = template;
        this.integrator = new IntegralImageFilter(this.integrated);
        this.shrinker = new Shrinker(0);
    }

    @Override
    public List<List<Image>> sliceUp(Image image) {
        int i;
        ArrayList<List<Image>> values = new ArrayList<List<Image>>();
        int imageHeight = image.getHeight();
        int rowThreshold = imageHeight / 10;
        double weight = 0.8;
        double range = image.getWidth() / 2;
        int windowSize = 10;
        int halfWindow = 5;
        int[] pixels = new int[imageHeight + 10];
        int[] pixelSum = new int[imageHeight + 10];
        int[] pixelSquare = new int[imageHeight + 10];
        int prevSum = 0;
        int prevSquare = 0;
        for (i = 5; i < imageHeight + 5; ++i) {
            image.iterateH(i - 5);
            int value = 0;
            while (image.hasNext()) {
                value += image.next();
            }
            pixels[i] = value;
            prevSum = pixelSum[i] = prevSum + value;
            prevSquare = pixelSquare[i] = prevSquare + value * value;
        }
        for (i = 0; i < 5; ++i) {
            pixelSum[i] = pixelSum[5];
            pixelSquare[i] = pixelSquare[5];
        }
        for (i = imageHeight + 5; i < imageHeight + 10; ++i) {
            pixelSum[i] = pixelSum[imageHeight + 4];
            pixelSquare[i] = pixelSquare[imageHeight + 4];
        }
        for (i = 5; i < imageHeight + 5; ++i) {
            double mx = (pixelSum[i + 5] - pixelSum[i - 5]) / 11;
            double mxSquares = (pixelSquare[i + 5] - pixelSquare[i - 5]) / 11;
            double variance = mxSquares - mx * mx;
            double thr = mx * (1.0 + weight * (Math.sqrt(variance) / range - 1.0));
            pixels[i] = (double)pixels[i] > thr ? 1 : 0;
        }
        PixelImage augmentedRow = new PixelImage(pixels, 1, imageHeight + 10);
        Image collapsedRow = augmentedRow.chisel(0, 5, 1, imageHeight);
        ArrayList<Image> candidateRows = new ArrayList<Image>();
        SlicerH slicerH = new SlicerH(collapsedRow, 0);
        slicerH.slice(0);
        while (slicerH.hasNext()) {
            Image rowDesc = slicerH.next();
            if (rowDesc.getHeight() < rowThreshold) continue;
            Image candidate = image.chisel(0, rowDesc.getOriginY() - 5, image.getWidth(), rowDesc.getHeight());
            candidateRows.add(candidate);
        }
        for (Image row : candidateRows) {
            ArrayList<Image> rowList = new ArrayList<Image>();
            SlicerV vslicer = new SlicerV(row, 0);
            vslicer.slice(0);
            while (vslicer.hasNext()) {
                rowList.add(this.shrinker.shrink(vslicer.next()));
            }
            values.add(rowList);
        }
        return values;
    }
}

