/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaocr.demos.android.utils.image;

import net.sf.javaocr.demos.android.utils.image.ImageProcessor;
import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.filter.SauvolaBinarisationFilter;
import net.sourceforge.javaocr.ocr.PixelImage;

public class SauvolaImageProcessor
implements ImageProcessor {
    public static final int SAUVOLA_WINDOW = 50;
    public static final int MEDIAN_WINDOW = 3;
    private static final double SAUVOLA_WEIGHT = 0.2;
    final int w;
    final int h;
    final int arrayWidth;
    final int arrayHeight;
    PixelImage processImage;
    PixelImage returnImage;
    private SauvolaBinarisationFilter sauvolaBinarisationFilter;

    public SauvolaImageProcessor(int arrayWidth, int arrayHeight, int w, int h, int above, int below) {
        this.h = h;
        this.w = w;
        this.arrayHeight = arrayHeight;
        this.arrayWidth = arrayWidth;
        this.processImage = new PixelImage(w + 50, h + 50);
        this.returnImage = (PixelImage)this.processImage.chisel(25, 25, w, h);
        this.sauvolaBinarisationFilter = new SauvolaBinarisationFilter(above, below, (Image)this.processImage, 256, 0.2, 50);
    }

    public PixelImage prepareImage(byte[] image, int offsetX, int offsetY) {
        int[] pixels = this.processImage.pixels;
        int firstLine = offsetY - 25;
        int lastLine = offsetY + this.h + 25;
        int scanStart = offsetX - 25 + this.arrayWidth * firstLine;
        int desIdx = 0;
        for (int i = firstLine; i < lastLine; ++i) {
            int scanEnd = scanStart + 50 + this.w;
            for (int j = scanStart; j < scanEnd; ++j) {
                pixels[desIdx++] = image[j] & 0xFF;
            }
            scanStart += this.arrayWidth;
        }
        this.sauvolaBinarisationFilter.process((Image)this.processImage);
        return this.returnImage;
    }
}

