/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.filter;

import java.util.Arrays;
import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.filter.AbstractSinglePixelFilter;

public class HistogramFilter
extends AbstractSinglePixelFilter {
    int[] defaultSmooth = new int[]{1, 2, 1};
    int[] histogramm;
    int totalCount;
    private static final int DEFAULT_BINS = 256;
    final int amount_bins;

    public HistogramFilter() {
        this(256);
    }

    public HistogramFilter(int amount_bins) {
        this.amount_bins = amount_bins;
        this.histogramm = new int[amount_bins];
    }

    public int[] getHistogramm() {
        return this.histogramm;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void reset() {
        Arrays.fill(this.histogramm, 0);
        this.totalCount = 0;
    }

    protected void processPixel(Image image) {
        ++this.totalCount;
        int n = image.next();
        this.histogramm[n] = this.histogramm[n] + 1;
    }

    public void smooth() {
        this.fold(this.defaultSmooth);
    }

    public void fold(int[] folder) throws IllegalArgumentException {
        if (folder.length % 2 == 0) {
            throw new IllegalArgumentException("folding array must have odd length");
        }
        int[] result = new int[this.amount_bins];
        int start = folder.length / 2;
        int end = this.histogramm.length - start;
        for (int i = start; i < end; ++i) {
            int sum = 0;
            for (int j = 0; j < folder.length; ++j) {
                sum += this.histogramm[i - start + j] * folder[j];
            }
            result[i] = sum / folder.length;
        }
        this.histogramm = result;
    }

    public int adaptiveThreshold() {
        return this.adaptiveThreshold(this.amount_bins / 2);
    }

    public int adaptiveThreshold(int threshold) {
        int mRight;
        int mLeft = this.computeM(0, threshold);
        int newThr = (mLeft + (mRight = this.computeM(threshold, this.amount_bins))) / 2;
        if (Math.abs(newThr - threshold) <= 1) {
            return threshold;
        }
        return this.adaptiveThreshold(newThr);
    }

    private int computeM(int from, int to) {
        float retval = 0.0f;
        float norm = 0.0f;
        for (int i = from; i < to; ++i) {
            retval += (float)(this.histogramm[i] * i);
            norm += (float)this.histogramm[i];
        }
        if (norm == 0.0f) {
            norm = 1.0f;
        }
        return (int)(retval / norm);
    }
}

