/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.ocr;

import net.sourceforge.javaocr.Image;

public abstract class AbstractLinearImage
implements Image {
    protected final int arrayWidth;
    protected final int arrayHeight;
    protected final int originX;
    protected final int originY;
    protected final int width;
    protected final int height;
    protected int currentIndex;
    protected final float aspectRatio;
    int step;
    int border;

    protected AbstractLinearImage(int arrayWidth, int arrayHeight) {
        this(arrayWidth, arrayHeight, 0, 0, arrayWidth, arrayHeight);
    }

    protected AbstractLinearImage(int arrayWidth, int arrayHeight, int originX, int originY, int width, int height) {
        this.height = height;
        this.width = width;
        this.arrayHeight = arrayHeight;
        this.originX = originX;
        this.originY = originY;
        this.arrayWidth = arrayWidth;
        this.aspectRatio = (float)width / (float)height;
    }

    public abstract int get();

    public abstract void put(int var1);

    public int get(int x, int y) {
        this.setCurrentIndex(x, y);
        return this.get();
    }

    protected void setCurrentIndex(int x, int y) {
        this.currentIndex = (y + this.originY) * this.arrayWidth + x + this.originX;
    }

    public void put(int x, int y, int value) {
        this.setCurrentIndex(x, y);
        this.put(value);
    }

    public int getArrayHeight() {
        return this.arrayHeight;
    }

    public int getArrayWidth() {
        return this.arrayWidth;
    }

    public float getAspectRatio() {
        return this.aspectRatio;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getOriginY() {
        return this.originY;
    }

    public boolean horizontalSpanEquals(int y, int from, int to, int value) {
        this.iterateH(y, from, to);
        while (this.hasNext()) {
            if (this.next() == value) continue;
            return false;
        }
        return true;
    }

    public boolean verticalSpanEquals(int x, int from, int to, int value) {
        this.iterateV(x, from, to);
        while (this.hasNext()) {
            if (this.next() == value) continue;
            return false;
        }
        return true;
    }

    public void iterateV(int x, int from, int to) {
        this.currentIndex = (from + this.originY - 1) * this.arrayWidth + x + this.originX;
        this.border = (to + this.originY) * this.arrayWidth + x + this.originX;
        this.step = this.arrayWidth;
    }

    public void iterateH(int y, int from, int to) {
        int base = (y + this.originY) * this.arrayWidth + this.originX - 1;
        this.currentIndex = base + from;
        this.border = base + to + 1;
        this.step = 1;
    }

    public void iterateH(int y) {
        this.iterateH(y, 0, this.width - 1);
    }

    public void iterateV(int x) {
        this.iterateV(x, 0, this.height - 1);
    }

    public boolean hasNext() {
        return this.currentIndex < this.border;
    }

    public int next() {
        this.currentIndex += this.step;
        return this.get();
    }

    public void next(int pixel) {
        this.currentIndex += this.step;
        this.put(pixel);
    }

    public void copy(Image dst) {
        int height = this.getHeight();
        for (int i = 0; i < height; ++i) {
            this.iterateH(i);
            dst.iterateH(i);
            while (this.hasNext()) {
                dst.next(this.next());
            }
        }
    }

    public void flip(Image dst) {
        int width = this.getWidth();
        for (int i = 0; i < width; ++i) {
            this.iterateV(i);
            dst.iterateH(i);
            while (this.hasNext()) {
                dst.next(this.next());
            }
        }
    }

    public String toString() {
        return "AbstractLinearImage{arrayHeight=" + this.arrayHeight + ", arrayWidth=" + this.arrayWidth + ", aspectRatio=" + this.aspectRatio + ", height=" + this.height + ", originX=" + this.originX + ", originY=" + this.originY + ", width=" + this.width + '}';
    }

    public Image row(int y) {
        return this.chisel(0, y, this.width, 1);
    }

    public Image column(int x) {
        return this.chisel(x, 0, 1, this.height);
    }
}

