/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.ocr;

import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.ocr.AbstractLinearImage;

public class ByteImage
extends AbstractLinearImage {
    byte[] image;

    public ByteImage(int width, int height) {
        this(new byte[width * height], width, height);
    }

    public ByteImage(byte[] image, int width, int height) {
        this(image, width, height, 0, 0, width, height);
    }

    public ByteImage(byte[] image, int arrayWidth, int arrayHeight, int originX, int originY, int width, int height) {
        super(arrayWidth, arrayHeight, originX, originY, width, height);
        this.image = image;
    }

    public int get() {
        return this.image[this.currentIndex] & 0xFF;
    }

    public void put(int value) {
        this.image[this.currentIndex] = (byte)value;
    }

    public Image chisel(int fromX, int fromY, int width, int height) {
        return new ByteImage(this.image, this.arrayWidth, this.arrayHeight, this.originX + fromX, this.originY + fromY, width, height);
    }

    public String toString() {
        return "ByteImage{} " + super.toString();
    }
}

