/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.plugin.cluster.extractor;

import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.cluster.FeatureExtractor;
import net.sourceforge.javaocr.filter.AbstractSinglePixelFilter;

public class FreeSpacesExtractor
extends AbstractSinglePixelFilter
implements FeatureExtractor {
    int[] workingScan;
    int spaceCount;
    int index;
    boolean free = false;
    int currentSpaceNumber;
    int reductionFactor;

    public int getSize() {
        return 1;
    }

    public double[] extract(Image image) {
        double[] retval = new double[1];
        this.process(image);
        retval[0] = this.spaceCount - this.reductionFactor;
        return retval;
    }

    public void process(Image image) {
        this.workingScan = new int[image.getWidth()];
        this.index = 0;
        this.free = false;
        this.spaceCount = 0;
        this.reductionFactor = 0;
        super.process(image);
    }

    protected void processPixel(Image image) {
        if (image.next() == 0) {
            if (!this.free) {
                if (this.workingScan[this.index] == 0) {
                    ++this.spaceCount;
                    this.currentSpaceNumber = this.spaceCount;
                } else {
                    this.currentSpaceNumber = this.workingScan[this.index];
                }
                this.free = true;
            } else if (this.workingScan[this.index] > 0 && this.workingScan[this.index] != this.currentSpaceNumber) {
                ++this.reductionFactor;
                this.currentSpaceNumber = this.workingScan[this.index];
                for (int i = this.index - 1; i >= 0 && this.workingScan[i] != 0; --i) {
                    this.workingScan[i] = this.currentSpaceNumber;
                }
            }
            this.workingScan[this.index] = this.currentSpaceNumber;
        } else {
            this.free = false;
            this.workingScan[this.index] = 0;
        }
        ++this.index;
        if (this.index >= this.workingScan.length) {
            this.index = 0;
            this.free = false;
        }
    }
}

