/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.plugin.morphology;

import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.plugin.morphology.AbstractMorphologyFilter;

public class ErosionFilter
extends AbstractMorphologyFilter {
    public ErosionFilter(Image strElem, Image dest) {
        this(strElem, dest, 255, 0);
    }

    public ErosionFilter(Image strElem, Image dest, int full, int empty) {
        super(strElem, dest, full, empty);
    }

    public void process(Image image) {
        int imageW = image.getWidth();
        int imageH = image.getHeight();
        image.chisel(0, 0, imageW, this.sizeT).copy(this.destImage.chisel(0, 0, imageW, this.sizeT));
        image.chisel(0, imageH - this.sizeB, imageW, this.sizeB).copy(this.destImage.chisel(0, imageH - this.sizeB, imageW, this.sizeB));
        image.chisel(0, 0, this.sizeL, imageH).copy(this.destImage.chisel(0, 0, this.sizeL, imageH));
        image.chisel(imageW - this.sizeR, 0, this.sizeR, imageH).copy(this.destImage.chisel(imageW - this.sizeR, 0, this.sizeR, imageH));
        for (int y = this.sizeT; y < imageH - this.sizeB; ++y) {
            for (int x = this.sizeL; x < imageW - this.sizeR; ++x) {
                Image nImage = image.chisel(x - this.sizeL, y - this.sizeT, this.seImageW, this.seImageH);
                this.destImage.put(x, y, this.processNeighborhood(nImage));
            }
        }
    }

    protected int processNeighborhood(Image nImage) {
        for (int i = 0; i < this.seImageH; ++i) {
            this.seImage.iterateH(i);
            nImage.iterateH(i);
            while (this.seImage.hasNext() && nImage.hasNext()) {
                this.seImage.next();
                nImage.next();
                if (this.seImage.get() != this.full || nImage.get() != this.empty) continue;
                return this.empty;
            }
        }
        return this.full;
    }
}

