/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.plugin.morphology;

import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.ImageFilter;
import net.sourceforge.javaocr.ocr.PixelImage;
import net.sourceforge.javaocr.plugin.morphology.DilationFilter;
import net.sourceforge.javaocr.plugin.morphology.ErosionFilter;

public class OpeningFilter
implements ImageFilter {
    protected ErosionFilter erosionFilter;
    protected Image tempImage;
    protected DilationFilter dilationFilter;
    protected Image destImage;

    public OpeningFilter(Image strElem, Image dest) {
        this(strElem, dest, 255, 0);
    }

    public OpeningFilter(Image strElem, Image dest, int full, int empty) {
        this.tempImage = new PixelImage(dest.getWidth(), dest.getHeight());
        this.erosionFilter = new ErosionFilter(strElem, this.tempImage, full, empty);
        this.destImage = dest;
        this.dilationFilter = new DilationFilter(strElem, this.destImage, full, empty);
    }

    public void process(Image image) {
        this.erosionFilter.process(image);
        this.dilationFilter.process(this.tempImage);
    }
}

