/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.api.sharedpreferences;

import android.content.SharedPreferences;
import org.androidannotations.api.sharedpreferences.AbstractPrefField;

public final class FloatPrefField
extends AbstractPrefField<Float> {
    FloatPrefField(SharedPreferences sharedPreferences, String key, Float defaultValue) {
        super(sharedPreferences, key, defaultValue);
    }

    @Override
    public Float getOr(Float defaultValue) {
        try {
            return Float.valueOf(this.sharedPreferences.getFloat(this.key, defaultValue.floatValue()));
        }
        catch (ClassCastException e) {
            try {
                String value = this.sharedPreferences.getString(this.key, "" + defaultValue);
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    @Override
    protected void putInternal(Float value) {
        this.apply(this.edit().putFloat(this.key, value.floatValue()));
    }
}

