/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import org.androidannotations.handler.AnnotationHandler;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.IdAnnotationHelper;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.model.AndroidSystemServices;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.process.ProcessHolder;
import org.androidannotations.rclass.IRClass;

public abstract class BaseAnnotationHandler<T extends GeneratedClassHolder>
implements AnnotationHandler<T> {
    private final String target;
    protected ProcessingEnvironment processingEnv;
    protected IdValidatorHelper validatorHelper;
    protected IRClass rClass;
    protected AndroidSystemServices androidSystemServices;
    protected AndroidManifest androidManifest;
    protected AnnotationElements validatedModel;
    protected ProcessHolder processHolder;

    public BaseAnnotationHandler(Class<?> targetClass, ProcessingEnvironment processingEnvironment) {
        this(targetClass.getCanonicalName(), processingEnvironment);
    }

    public BaseAnnotationHandler(String target, ProcessingEnvironment processingEnvironment) {
        this.target = target;
        this.processingEnv = processingEnvironment;
    }

    @Override
    public void setAndroidEnvironment(IRClass rClass, AndroidSystemServices androidSystemServices, AndroidManifest androidManifest) {
        this.rClass = rClass;
        this.androidSystemServices = androidSystemServices;
        this.androidManifest = androidManifest;
        this.initValidatorHelper();
    }

    private void initValidatorHelper() {
        IdAnnotationHelper annotationHelper = new IdAnnotationHelper(this.processingEnv, this.target, this.rClass);
        this.validatorHelper = new IdValidatorHelper(annotationHelper);
    }

    @Override
    public void setValidatedModel(AnnotationElements validatedModel) {
        this.validatedModel = validatedModel;
    }

    @Override
    public void setProcessHolder(ProcessHolder processHolder) {
        this.processHolder = processHolder;
    }

    public ProcessingEnvironment processingEnvironment() {
        return this.processHolder.processingEnvironment();
    }

    public ProcessHolder.Classes classes() {
        return this.processHolder.classes();
    }

    public JCodeModel codeModel() {
        return this.processHolder.codeModel();
    }

    public JClass refClass(String fullyQualifiedClassName) {
        return this.processHolder.refClass(fullyQualifiedClassName);
    }

    public JClass refClass(Class<?> clazz) {
        return this.processHolder.refClass(clazz);
    }

    public void generateApiClass(Element originatingElement, Class<?> apiClass) {
        this.processHolder.generateApiClass(originatingElement, apiClass);
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public boolean validate(Element element, AnnotationElements validatedElements) {
        IsValid valid = new IsValid();
        this.validate(element, validatedElements, valid);
        return valid.isValid();
    }

    protected abstract void validate(Element var1, AnnotationElements var2, IsValid var3);
}

