/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.OptionsItem;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.IdAnnotationHelper;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.HasOptionsMenu;
import org.androidannotations.model.AndroidSystemServices;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.rclass.IRClass;

public class OptionsItemHandler
extends BaseAnnotationHandler<HasOptionsMenu> {
    private IdAnnotationHelper annotationHelper;

    public OptionsItemHandler(ProcessingEnvironment processingEnvironment) {
        super(OptionsItem.class, processingEnvironment);
    }

    @Override
    public void setAndroidEnvironment(IRClass rClass, AndroidSystemServices androidSystemServices, AndroidManifest androidManifest) {
        super.setAndroidEnvironment(rClass, androidSystemServices, androidManifest);
        this.annotationHelper = new IdAnnotationHelper(this.processingEnv, this.getTarget(), rClass);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEActivityOrEFragment(element, validatedElements, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.ID, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.doesntThrowException(element, valid);
        this.validatorHelper.uniqueId(element, validatedElements, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoidOrBoolean(executableElement, valid);
        this.validatorHelper.param.zeroOrOneMenuItemParameter(executableElement, valid);
    }

    @Override
    public void process(Element element, HasOptionsMenu holder) {
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        TypeMirror returnType = executableElement.getReturnType();
        boolean returnMethodResult = returnType.getKind() != TypeKind.VOID;
        boolean hasItemParameter = parameters.size() == 1;
        List<JFieldRef> idsRefs = this.annotationHelper.extractAnnotationFieldRefs(this.processHolder, element, IRClass.Res.ID, true);
        JExpression ifExpr = holder.getOnOptionsItemSelectedItemId().eq(idsRefs.get(0));
        for (int i = 1; i < idsRefs.size(); ++i) {
            ifExpr = ifExpr.cor(holder.getOnOptionsItemSelectedItemId().eq(idsRefs.get(i)));
        }
        JBlock itemIfBody = holder.getOnOptionsItemSelectedIfElseBlock()._if(ifExpr)._then();
        JInvocation methodCall = JExpr.invoke(methodName);
        if (returnMethodResult) {
            itemIfBody._return(methodCall);
        } else {
            itemIfBody.add(methodCall);
            itemIfBody._return(JExpr.TRUE);
        }
        if (hasItemParameter) {
            methodCall.arg(holder.getOnOptionsItemSelectedItem());
        }
    }
}

