/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.annotations.UiThread;
import org.androidannotations.handler.AbstractRunnableHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.holder.EComponentHolder;

public class UiThreadHandler
extends AbstractRunnableHandler {
    private static final String METHOD_CUR_THREAD = "currentThread";
    private static final String METHOD_MAIN_LOOPER = "getMainLooper";
    private static final String METHOD_GET_THREAD = "getThread";
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public UiThreadHandler(ProcessingEnvironment processingEnvironment) {
        super(UiThread.class, processingEnvironment);
    }

    @Override
    public void process(Element element, EComponentHolder holder) throws Exception {
        ExecutableElement executableElement = (ExecutableElement)element;
        JMethod delegatingMethod = this.codeModelHelper.overrideAnnotatedMethod(executableElement, holder);
        JBlock previousBody = this.codeModelHelper.removeBody(delegatingMethod);
        JDefinedClass anonymousRunnableClass = this.codeModelHelper.createDelegatingAnonymousRunnableClass(holder, previousBody);
        UiThread annotation = element.getAnnotation(UiThread.class);
        long delay = annotation.delay();
        UiThread.Propagation propagation = annotation.propagation();
        if (delay == 0L) {
            if (propagation == UiThread.Propagation.REUSE) {
                this.addUIThreadCheck(delegatingMethod, previousBody, holder);
            }
            delegatingMethod.body().invoke((JExpression)holder.getHandler(), "post").arg(JExpr._new(anonymousRunnableClass));
        } else {
            delegatingMethod.body().invoke((JExpression)holder.getHandler(), "postDelayed").arg(JExpr._new(anonymousRunnableClass)).arg(JExpr.lit(delay));
        }
    }

    private void addUIThreadCheck(JMethod delegatingMethod, JBlock previousBody, EComponentHolder holder) throws JClassAlreadyExistsException {
        JClass tClass = holder.classes().THREAD;
        JClass lClass = holder.classes().LOOPER;
        JInvocation lhs = tClass.staticInvoke(METHOD_CUR_THREAD);
        JInvocation rhs = lClass.staticInvoke(METHOD_MAIN_LOOPER).invoke(METHOD_GET_THREAD);
        JConditional con = delegatingMethod.body()._if(JOp.eq(lhs, rhs));
        JBlock thenBlock = con._then().add(previousBody);
        thenBlock._return();
    }
}

