/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.OnActivityResult;
import org.androidannotations.annotations.Receiver;
import org.androidannotations.annotations.ReceiverAction;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.TargetAnnotationHelper;
import org.androidannotations.process.IsValid;

public class ValidatorParameterHelper {
    private static final List<String> ANDROID_SHERLOCK_MENU_ITEM_QUALIFIED_NAMES = Arrays.asList("android.view.MenuItem", "com.actionbarsherlock.view.MenuItem");
    private static final List<String> EDITOR_ACTION_ALLOWED_PARAMETER_TYPES = Arrays.asList("android.widget.TextView", CanonicalNameConstants.INTEGER, "int", "android.view.KeyEvent");
    protected final TargetAnnotationHelper annotationHelper;

    public ValidatorParameterHelper(TargetAnnotationHelper targetAnnotationHelper) {
        this.annotationHelper = targetAnnotationHelper;
    }

    public void zeroOrOneParameter(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() > 1) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with zero or one parameter, instead of " + parameters.size());
        }
    }

    public void zeroParameter(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() > 0) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with zero parameter, instead of " + parameters.size());
        }
    }

    public void zeroOrOneViewParameter(ExecutableElement executableElement, IsValid valid) {
        this.zeroOrOneSpecificParameter(executableElement, "android.view.View", valid);
    }

    public void zeroOrOneMenuItemParameter(ExecutableElement executableElement, IsValid valid) {
        this.zeroOrOneSpecificParameter(executableElement, ANDROID_SHERLOCK_MENU_ITEM_QUALIFIED_NAMES, valid);
    }

    public void zeroOrOneIntentParameter(ExecutableElement executableElement, IsValid isValid) {
        this.zeroOrOneSpecificParameter(executableElement, "android.content.Intent", isValid);
    }

    public void zeroOrOneSpecificParameter(ExecutableElement executableElement, String parameterTypeQualifiedName, IsValid valid) {
        this.zeroOrOneSpecificParameter(executableElement, Arrays.asList(parameterTypeQualifiedName), valid);
    }

    public void zeroOrOneSpecificParameter(ExecutableElement executableElement, List<String> parameterTypeQualifiedNames, IsValid valid) {
        VariableElement parameter;
        TypeMirror parameterType;
        this.zeroOrOneParameter(executableElement, valid);
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() == 1 && !parameterTypeQualifiedNames.contains((parameterType = (parameter = parameters.get(0)).asType()).toString())) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with no parameter or a parameter of type " + parameterTypeQualifiedNames + ", not " + parameterType);
        }
    }

    public void zeroOrOneBundleParameter(ExecutableElement executableElement, IsValid valid) {
        this.zeroOrOneSpecificParameter(executableElement, "android.os.Bundle", valid);
    }

    public void hasOneOrTwoParametersAndFirstIsBoolean(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() < 1 || parameters.size() > 2) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with 1 or 2 parameter, instead of " + parameters.size());
        } else {
            VariableElement firstParameter = parameters.get(0);
            TypeKind parameterKind = firstParameter.asType().getKind();
            if (parameterKind != TypeKind.BOOLEAN && !firstParameter.toString().equals(CanonicalNameConstants.BOOLEAN)) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(executableElement, "the first parameter should be a boolean");
            }
        }
    }

    public void hasZeroOrOneCompoundButtonParameter(ExecutableElement executableElement, IsValid valid) {
        this.hasZeroOrOneParameterOfType("android.widget.CompoundButton", executableElement, valid);
    }

    public void hasZeroOrOneBooleanParameter(ExecutableElement executableElement, IsValid valid) {
        this.hasZeroOrOneParameterOfPrimitiveType(CanonicalNameConstants.BOOLEAN, TypeKind.BOOLEAN, executableElement, valid);
    }

    public void hasZeroOrOneMotionEventParameter(ExecutableElement executableElement, IsValid valid) {
        this.hasZeroOrOneParameterOfType("android.view.MotionEvent", executableElement, valid);
    }

    public void hasZeroOrOneViewParameter(ExecutableElement executableElement, IsValid valid) {
        this.hasZeroOrOneParameterOfType("android.view.View", executableElement, valid);
    }

    private void hasZeroOrOneParameterOfType(String typeCanonicalName, ExecutableElement executableElement, IsValid valid) {
        boolean parameterOfTypeFound = false;
        for (VariableElement variableElement : executableElement.getParameters()) {
            String parameterType = variableElement.asType().toString();
            if (!parameterType.equals(typeCanonicalName)) continue;
            if (parameterOfTypeFound) {
                this.annotationHelper.printAnnotationError(executableElement, "You can declare only one parameter of type " + typeCanonicalName);
                valid.invalidate();
            }
            parameterOfTypeFound = true;
        }
    }

    private void hasZeroOrOneParameterOfPrimitiveType(String typeCanonicalName, TypeKind typeKind, ExecutableElement executableElement, IsValid valid) {
        boolean parameterOfTypeFound = false;
        for (VariableElement variableElement : executableElement.getParameters()) {
            if (variableElement.asType().getKind() != typeKind && !variableElement.asType().toString().equals(typeCanonicalName)) continue;
            if (parameterOfTypeFound) {
                this.annotationHelper.printAnnotationError(executableElement, "You can declare only one parameter of type " + typeKind.name() + " or " + typeCanonicalName);
                valid.invalidate();
            }
            parameterOfTypeFound = true;
        }
    }

    public void hasNoOtherParameterThanCompoundButtonOrBoolean(ExecutableElement executableElement, IsValid valid) {
        String[] types = new String[]{"android.widget.CompoundButton", CanonicalNameConstants.BOOLEAN, "boolean"};
        this.hasNotOtherParameterThanTypes(types, executableElement, valid);
    }

    public void hasNoOtherParameterThanMotionEventOrView(ExecutableElement executableElement, IsValid valid) {
        String[] types = new String[]{"android.view.MotionEvent", "android.view.View"};
        this.hasNotOtherParameterThanTypes(types, executableElement, valid);
    }

    public void hasNoOtherParameterThanViewOrBoolean(ExecutableElement executableElement, IsValid valid) {
        String[] types = new String[]{"android.view.View", CanonicalNameConstants.BOOLEAN, "boolean"};
        this.hasNotOtherParameterThanTypes(types, executableElement, valid);
    }

    private void hasNotOtherParameterThanTypes(String[] typesCanonicalNames, ExecutableElement executableElement, IsValid valid) {
        List<String> types = Arrays.asList(typesCanonicalNames);
        for (VariableElement variableElement : executableElement.getParameters()) {
            String parameterType = variableElement.asType().toString();
            if (types.contains(parameterType)) continue;
            this.annotationHelper.printAnnotationError(executableElement, "You can declare only parameters of type " + Arrays.toString(typesCanonicalNames));
            valid.invalidate();
        }
    }

    public void hasNoOtherParameterThanContextOrIntentOrReceiverExtraAnnotated(ExecutableElement executableElement, IsValid valid) {
        String[] types = new String[]{"android.content.Context", "android.content.Intent"};
        this.hasNotOtherParameterThanTypesOrAnnotatedWith(types, Receiver.Extra.class, executableElement, valid);
    }

    public void hasNoOtherParameterThanContextOrIntentOrReceiverActionExtraAnnotated(ExecutableElement executableElement, IsValid valid) {
        String[] types = new String[]{"android.content.Context", "android.content.Intent"};
        this.hasNotOtherParameterThanTypesOrAnnotatedWith(types, ReceiverAction.Extra.class, executableElement, valid);
    }

    public void hasNoOtherParameterThanIntentOrIntOrOnActivityResultExtraAnnotated(ExecutableElement executableElement, IsValid valid) {
        String[] types = new String[]{"android.content.Intent", CanonicalNameConstants.INTEGER, "int"};
        this.hasNotOtherParameterThanTypesOrAnnotatedWith(types, OnActivityResult.Extra.class, executableElement, valid);
    }

    public void hasNotOtherParameterThanTypesOrAnnotatedWith(String[] typesCanonicalNames, Class<? extends Annotation> annotationClass, ExecutableElement executableElement, IsValid valid) {
        List<String> types = Arrays.asList(typesCanonicalNames);
        for (VariableElement variableElement : executableElement.getParameters()) {
            String parameterType = variableElement.asType().toString();
            if (types.contains(parameterType) || variableElement.getAnnotation(annotationClass) != null) continue;
            this.annotationHelper.printAnnotationError(executableElement, "You can declare only parameters of type " + Arrays.toString(typesCanonicalNames) + " or parameters annotated with @" + annotationClass.getCanonicalName());
            valid.invalidate();
        }
    }

    public void hasOneOrTwoParametersAndFirstIsDb(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() < 1) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "There should be at least 1 parameter: a android.database.sqlite.SQLiteDatabase");
        } else {
            VariableElement firstParameter = parameters.get(0);
            String firstParameterType = firstParameter.asType().toString();
            if (!firstParameterType.equals("android.database.sqlite.SQLiteDatabase")) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(executableElement, "the first parameter must be a android.database.sqlite.SQLiteDatabase, not a " + firstParameterType);
            }
        }
    }

    public void hasExactlyOneParameter(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() != 1) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with exactly one parameter, instead of " + parameters.size());
        }
    }

    public void hasAtMostOneTextViewParameter(ExecutableElement executableElement, IsValid valid) {
        this.hasAtMostOneSpecificParameter(executableElement, "android.widget.TextView", valid);
    }

    public void hasAtMostOneIntegerParameter(ExecutableElement executableElement, IsValid valid) {
        List<String> integers = Arrays.asList(CanonicalNameConstants.INTEGER, "integer");
        this.hasAtMostOneSpecificParameter(executableElement, integers, valid);
    }

    public void hasAtMostOneKeyEventParameter(ExecutableElement executableElement, IsValid valid) {
        this.hasAtMostOneSpecificParameter(executableElement, "android.view.KeyEvent", valid);
    }

    public void hasAtMostOneSpecificParameter(ExecutableElement executableElement, String qualifiedName, IsValid valid) {
        this.hasAtMostOneSpecificParameter(executableElement, Arrays.asList(qualifiedName), valid);
    }

    public void hasAtMostOneSpecificParameter(ExecutableElement executableElement, List<String> qualifiedNames, IsValid valid) {
        boolean hasOneMatchingParameter = false;
        for (VariableElement variableElement : executableElement.getParameters()) {
            if (!qualifiedNames.contains(variableElement.asType().toString())) continue;
            if (hasOneMatchingParameter) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(executableElement, "%s can't have more than one parameter of type " + variableElement.asType().toString());
                continue;
            }
            hasOneMatchingParameter = true;
        }
    }

    public void hasNoOtherParameterFromATextViewAnIntegerAndAKeyEvent(ExecutableElement executableElement, IsValid valid) {
        for (VariableElement variableElement : executableElement.getParameters()) {
            String parameterType = variableElement.asType().toString();
            if (EDITOR_ACTION_ALLOWED_PARAMETER_TYPES.contains(parameterType)) continue;
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only have TextView, int and/or KeyEvent parameters");
        }
    }
}

