/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.EditorAction;
import org.androidannotations.handler.AbstractViewListenerHandler;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class EditorActionHandler
extends AbstractViewListenerHandler {
    public EditorActionHandler(ProcessingEnvironment processingEnvironment) {
        super(EditorAction.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        super.validate(element, validatedElements, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoidOrBoolean(executableElement, valid);
        this.validatorHelper.param.hasAtMostOneTextViewParameter(executableElement, valid);
        this.validatorHelper.param.hasAtMostOneIntegerParameter(executableElement, valid);
        this.validatorHelper.param.hasAtMostOneKeyEventParameter(executableElement, valid);
        this.validatorHelper.param.hasNoOtherParameterFromATextViewAnIntegerAndAKeyEvent(executableElement, valid);
    }

    @Override
    protected void makeCall(JBlock listenerMethodBody, JInvocation call, TypeMirror returnType) {
        boolean returnMethodResult;
        boolean bl = returnMethodResult = returnType.getKind() != TypeKind.VOID;
        if (returnMethodResult) {
            listenerMethodBody._return(call);
        } else {
            listenerMethodBody.add(call);
            listenerMethodBody._return(JExpr.TRUE);
        }
    }

    @Override
    protected void processParameters(EComponentWithViewSupportHolder holder, JMethod listenerMethod, JInvocation call, List<? extends VariableElement> userParameters) {
        JVar textView = listenerMethod.param(this.classes().TEXT_VIEW, "textView");
        JVar actionId = listenerMethod.param(this.codeModel().INT, "actionId");
        JVar event = listenerMethod.param(this.classes().KEY_EVENT, "event");
        for (VariableElement variableElement : userParameters) {
            String paramClassQualifiedName = variableElement.asType().toString();
            if (paramClassQualifiedName.equals("android.widget.TextView")) {
                call.arg(textView);
                continue;
            }
            if (paramClassQualifiedName.equals(CanonicalNameConstants.INTEGER) || paramClassQualifiedName.equals(this.codeModel().INT.fullName())) {
                call.arg(actionId);
                continue;
            }
            if (!paramClassQualifiedName.equals("android.view.KeyEvent")) continue;
            call.arg(event);
        }
    }

    @Override
    protected JMethod createListenerMethod(JDefinedClass listenerAnonymousClass) {
        return listenerAnonymousClass.method(1, this.codeModel().BOOLEAN, "onEditorAction");
    }

    @Override
    protected String getSetterName() {
        return "setOnEditorActionListener";
    }

    @Override
    protected JClass getListenerClass() {
        return this.classes().TEXT_VIEW_ON_EDITOR_ACTION_LISTENER;
    }

    @Override
    protected JClass getListenerTargetClass() {
        return this.classes().TEXT_VIEW;
    }
}

