/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.rclass;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.androidannotations.helper.Option;
import org.androidannotations.logger.Logger;
import org.androidannotations.logger.LoggerFactory;
import org.androidannotations.rclass.IRClass;
import org.androidannotations.rclass.RClass;

public class AndroidRClassFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AndroidRClassFinder.class);
    private final ProcessingEnvironment processingEnv;

    public AndroidRClassFinder(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public Option<IRClass> find() {
        Elements elementUtils = this.processingEnv.getElementUtils();
        TypeElement androidRType = elementUtils.getTypeElement("android.R");
        if (androidRType == null) {
            LOGGER.error("The android.R class cannot be found", new Object[0]);
            return Option.absent();
        }
        LOGGER.info("Found Android class: {}", androidRType.toString());
        return Option.of(new RClass(androidRType));
    }
}

