/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.testutils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassFinder {
    private Map<URL, String> classpathLocations = new HashMap<URL, String>();
    private Map<Class<?>, URL> results = new HashMap();
    private List<Throwable> errors = new ArrayList<Throwable>();
    private static final FileFilter DIRECTORIES_ONLY = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.exists() && f.isDirectory();
        }
    };
    private static final Comparator<URL> URL_COMPARATOR = new Comparator<URL>(){

        @Override
        public int compare(URL u1, URL u2) {
            return String.valueOf(u1).compareTo(String.valueOf(u2));
        }
    };
    private static final Comparator<Class<?>> CLASS_COMPARATOR = new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> c1, Class<?> c2) {
            return String.valueOf(c1).compareTo(String.valueOf(c2));
        }
    };

    public ClassFinder() {
        this.refreshLocations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refreshLocations() {
        Map<URL, String> map = this.classpathLocations;
        synchronized (map) {
            this.classpathLocations = this.getClasspathLocations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Class<?>> findClassesInPackage(String packageName) {
        Map<URL, String> map = this.classpathLocations;
        synchronized (map) {
            Map<Class<?>, URL> map2 = this.results;
            synchronized (map2) {
                this.errors = new ArrayList<Throwable>();
                this.results = new TreeMap(CLASS_COMPARATOR);
                return this.findSubclasses(this.classpathLocations, packageName);
            }
        }
    }

    public final List<Throwable> getErrors() {
        return new ArrayList<Throwable>(this.errors);
    }

    public final URL getLocationOf(Class<?> cls) {
        if (this.results != null) {
            return this.results.get(cls);
        }
        return null;
    }

    public final Map<URL, String> getClasspathLocations() {
        TreeMap<URL, String> map = new TreeMap<URL, String>(URL_COMPARATOR);
        File file = null;
        String pathSep = System.getProperty("path.separator");
        String classpath = System.getProperty("java.class.path");
        StringTokenizer st = new StringTokenizer(classpath, pathSep);
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            file = new File(path);
            this.include(null, file, map);
        }
        return map;
    }

    private void include(String name, File file, Map<URL, String> map) {
        File[] dirs;
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            this.includeJar(file, map);
            return;
        }
        name = name == null ? "" : name + ".";
        for (File dir : dirs = file.listFiles(DIRECTORIES_ONLY)) {
            try {
                map.put(new URL("file://" + dir.getCanonicalPath()), name + dir.getName());
            }
            catch (IOException ioe) {
                return;
            }
            this.include(name + dir.getName(), dir, map);
        }
    }

    private void includeJar(File file, Map<URL, String> map) {
        if (file.isDirectory()) {
            return;
        }
        URL jarURL = null;
        JarFile jar = null;
        try {
            jarURL = new URL("file:/" + file.getCanonicalPath());
            jarURL = new URL("jar:" + jarURL.toExternalForm() + "!/");
            JarURLConnection conn = (JarURLConnection)jarURL.openConnection();
            jar = conn.getJarFile();
        }
        catch (Exception e) {
            return;
        }
        if (jar == null || jarURL == null) {
            return;
        }
        map.put(jarURL, "");
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (!entry.isDirectory() || entry.getName().toUpperCase().equals("META-INF/")) continue;
            try {
                map.put(new URL(jarURL.toExternalForm() + entry.getName()), ClassFinder.packageNameFor(entry));
            }
            catch (MalformedURLException murl) {}
        }
    }

    private static String packageNameFor(JarEntry entry) {
        if (entry == null) {
            return "";
        }
        String s = entry.getName();
        if (s == null) {
            return "";
        }
        if (s.length() == 0) {
            return s;
        }
        if (s.startsWith("/")) {
            s = s.substring(1, s.length());
        }
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        return s.replace('/', '.');
    }

    private List<Class<?>> findSubclasses(Map<URL, String> locations, String searchingPackageName) {
        List<Class<?>> v = Collections.synchronizedList(new ArrayList());
        List<Class<?>> w = null;
        for (URL url : locations.keySet()) {
            String packageName = locations.get(url);
            if (!packageName.startsWith(searchingPackageName) || (w = this.findSubclasses(url, packageName, searchingPackageName)) == null || w.size() <= 0) continue;
            v.addAll(w);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Class<?>> findSubclasses(URL location, String packageName, String searchingPackageName) {
        Map<Class<?>, URL> map = this.results;
        synchronized (map) {
            TreeMap thisResult = new TreeMap(CLASS_COMPARATOR);
            List<Class<?>> v = Collections.synchronizedList(new ArrayList());
            ArrayList<URL> knownLocations = new ArrayList<URL>();
            knownLocations.add(location);
            for (URL url : knownLocations) {
                Class<?> c;
                String classname;
                File directory = new File(url.getFile());
                if (directory.exists()) {
                    String[] files;
                    for (String file : files = directory.list()) {
                        if (!file.endsWith(".class")) continue;
                        classname = file.substring(0, file.length() - 6);
                        try {
                            c = Class.forName(packageName + "." + classname);
                            if (!packageName.startsWith(searchingPackageName)) continue;
                            thisResult.put(c, url);
                        }
                        catch (Exception ex) {
                            this.errors.add(ex);
                        }
                    }
                    continue;
                }
                try {
                    JarURLConnection conn = (JarURLConnection)url.openConnection();
                    JarFile jarFile = conn.getJarFile();
                    Enumeration<JarEntry> e = jarFile.entries();
                    while (e.hasMoreElements()) {
                        JarEntry entry = e.nextElement();
                        String entryname = entry.getName();
                        if (entry.isDirectory() || !entryname.endsWith(".class")) continue;
                        classname = entryname.substring(0, entryname.length() - 6);
                        if (classname.startsWith("/")) {
                            classname = classname.substring(1);
                        }
                        classname = classname.replace('/', '.');
                        try {
                            c = Class.forName(classname);
                            if (!c.getPackage().getName().startsWith(searchingPackageName)) continue;
                            thisResult.put(c, url);
                        }
                        catch (ClassNotFoundException cnfex) {
                            this.errors.add(cnfex);
                        }
                        catch (NoClassDefFoundError ncdfe) {
                            this.errors.add(ncdfe);
                        }
                        catch (UnsatisfiedLinkError ule) {
                            this.errors.add(ule);
                        }
                        catch (Exception exception) {
                            this.errors.add(exception);
                        }
                        catch (Error error) {
                            this.errors.add(error);
                        }
                    }
                }
                catch (IOException ioex) {
                    this.errors.add(ioex);
                }
            }
            this.results.putAll(thisResult);
            for (Class aClass : thisResult.keySet()) {
                v.add(aClass);
            }
            return v;
        }
    }

    public static void main(String[] args) {
        ClassFinder finder = null;
        List<Class<?>> v = null;
        List<Throwable> errors = null;
        if (args.length != 1) {
            System.out.println("Usage: java ClassFinder <package.name>");
            return;
        }
        finder = new ClassFinder();
        v = finder.findClassesInPackage(args[0]);
        errors = finder.getErrors();
        System.out.println("RESULTS:");
        if (v != null && v.size() > 0) {
            for (Class<?> cls : v) {
                System.out.println(cls + " in " + (finder != null ? String.valueOf(finder.getLocationOf(cls)) : "?"));
            }
            if (errors != null && errors.size() > 0) {
                System.out.println("Errors:");
                for (Throwable error : errors) {
                    error.printStackTrace();
                }
            }
        } else {
            System.out.println("No subclasses in package " + args[0] + " found.");
        }
    }
}

