/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.fastagi;

import net.sf.asterisk.fastagi.AGIChannel;
import net.sf.asterisk.fastagi.AGIConnectionHandler;
import net.sf.asterisk.fastagi.AGIException;
import net.sf.asterisk.fastagi.AGIScript;
import net.sf.asterisk.fastagi.command.AGICommand;
import net.sf.asterisk.fastagi.command.AnswerCommand;
import net.sf.asterisk.fastagi.reply.AGIReply;

public abstract class BaseAGIScript
implements AGIScript {
    protected void answer() throws AGIException {
        this.sendCommand(new AnswerCommand());
    }

    protected void hangup() throws AGIException {
        this.getChannel().hangup();
    }

    protected void setAutoHangup(int time) throws AGIException {
        this.getChannel().setAutoHangup(time);
    }

    protected void setCallerId(String callerId) throws AGIException {
        this.getChannel().setCallerId(callerId);
    }

    protected void playMusicOnHold() throws AGIException {
        this.getChannel().playMusicOnHold();
    }

    protected void playMusicOnHold(String musicOnHoldClass) throws AGIException {
        this.getChannel().playMusicOnHold(musicOnHoldClass);
    }

    protected void stopMusicOnHold() throws AGIException {
        this.getChannel().stopMusicOnHold();
    }

    protected int getChannelStatus() throws AGIException {
        return this.getChannel().getChannelStatus();
    }

    protected String getData(String file) throws AGIException {
        return this.getChannel().getData(file);
    }

    protected String getData(String file, int timeout) throws AGIException {
        return this.getChannel().getData(file, timeout);
    }

    protected String getData(String file, int timeout, int maxDigits) throws AGIException {
        return this.getChannel().getData(file, timeout, maxDigits);
    }

    protected char getOption(String file, String escapeDigits) throws AGIException {
        return this.getChannel().getOption(file, escapeDigits);
    }

    protected char getOption(String file, String escapeDigits, int timeout) throws AGIException {
        return this.getChannel().getOption(file, escapeDigits, timeout);
    }

    protected int exec(String application) throws AGIException {
        return this.getChannel().exec(application);
    }

    protected int exec(String application, String options) throws AGIException {
        return this.getChannel().exec(application, options);
    }

    protected void setContext(String context) throws AGIException {
        this.getChannel().setContext(context);
    }

    protected void setExtension(String extension) throws AGIException {
        this.getChannel().setExtension(extension);
    }

    protected void setPriority(String priority) throws AGIException {
        this.getChannel().setPriority(priority);
    }

    protected void streamFile(String file) throws AGIException {
        this.getChannel().streamFile(file);
    }

    protected char streamFile(String file, String escapeDigits) throws AGIException {
        return this.getChannel().streamFile(file, escapeDigits);
    }

    protected void sayDigits(String digits) throws AGIException {
        this.getChannel().sayDigits(digits);
    }

    protected char sayDigits(String digits, String escapeDigits) throws AGIException {
        return this.getChannel().sayDigits(digits, escapeDigits);
    }

    protected void sayNumber(String number) throws AGIException {
        this.getChannel().sayNumber(number);
    }

    protected char sayNumber(String number, String escapeDigits) throws AGIException {
        return this.getChannel().sayNumber(number, escapeDigits);
    }

    protected void sayPhonetic(String text) throws AGIException {
        this.getChannel().sayPhonetic(text);
    }

    protected char sayPhonetic(String text, String escapeDigits) throws AGIException {
        return this.getChannel().sayPhonetic(text, escapeDigits);
    }

    protected void sayAlpha(String text) throws AGIException {
        this.getChannel().sayAlpha(text);
    }

    protected char sayAlpha(String text, String escapeDigits) throws AGIException {
        return this.getChannel().sayAlpha(text, escapeDigits);
    }

    protected void sayTime(long time) throws AGIException {
        this.getChannel().sayTime(time);
    }

    protected char sayTime(long time, String escapeDigits) throws AGIException {
        return this.getChannel().sayTime(time, escapeDigits);
    }

    protected String getVariable(String name) throws AGIException {
        return this.getChannel().getVariable(name);
    }

    protected void setVariable(String name, String value) throws AGIException {
        this.getChannel().setVariable(name, value);
    }

    protected char waitForDigit(int timeout) throws AGIException {
        return this.getChannel().waitForDigit(timeout);
    }

    protected String getFullVariable(String name) throws AGIException {
        return this.getChannel().getFullVariable(name);
    }

    protected String getFullVariable(String name, String channel) throws AGIException {
        return this.getChannel().getFullVariable(name, channel);
    }

    protected void sayDateTime(long time) throws AGIException {
        this.getChannel().sayDateTime(time);
    }

    protected char sayDateTime(long time, String escapeDigits) throws AGIException {
        return this.getChannel().sayDateTime(time, escapeDigits);
    }

    protected char sayDateTime(long time, String escapeDigits, String format) throws AGIException {
        return this.getChannel().sayDateTime(time, escapeDigits, format);
    }

    protected char sayDateTime(long time, String escapeDigits, String format, String timezone) throws AGIException {
        return this.getChannel().sayDateTime(time, escapeDigits, format, timezone);
    }

    private AGIReply sendCommand(AGICommand command) throws AGIException {
        return this.getChannel().sendCommand(command);
    }

    private AGIChannel getChannel() {
        AGIChannel channel = AGIConnectionHandler.getChannel();
        if (channel == null) {
            throw new RuntimeException("Trying to send command from an invalid thread");
        }
        return channel;
    }
}

