/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.manager;

import net.sf.asterisk.manager.ManagerConnection;
import net.sf.asterisk.manager.action.PingAction;
import net.sf.asterisk.manager.response.ManagerResponse;
import net.sf.asterisk.util.Log;
import net.sf.asterisk.util.LogFactory;

public class PingThread
extends Thread {
    private static final long DEFAULT_INTERVAL = 2000L;
    private final Log logger = LogFactory.getLog(this.getClass());
    private long interval;
    private boolean die;
    private ManagerConnection connection;

    public PingThread(ManagerConnection connection) {
        this.connection = connection;
        this.interval = 2000L;
        this.die = false;
        this.setName("Ping");
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void die() {
        this.die = true;
        this.interrupt();
    }

    public void run() {
        while (!this.die) {
            try {
                PingThread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.die) break;
            try {
                ManagerResponse response = this.connection.sendAction(new PingAction());
                this.logger.debug("Ping response: " + response);
            }
            catch (Exception e) {
                this.logger.warn("Exception on sending Ping", e);
            }
        }
    }
}

