/*
 *  Copyright 2004-2006 Stefan Reuter
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package org.asteriskjava.manager.event;

/**
 * Abstract base class for events triggered in response to an OriginateAction.
 * 
 * @see org.asteriskjava.manager.action.OriginateAction
 * @author srt
 * @version $Id: AbstractOriginateEvent.java 459 2006-07-06 23:24:57Z srt $
 */
public abstract class AbstractOriginateEvent extends ResponseEvent
{
    private String channel;
    private String context;
    private String exten;
    private String uniqueId;
    private Integer reason;
    private String callerIdNum;
    private String callerIdName;

    /**
     * @param source
     */
    protected AbstractOriginateEvent(Object source)
    {
        super(source);
    }

    /**
     * Returns the name of the channel to connect to the outgoing call.
     */
    public String getChannel()
    {
        return channel;
    }

    /**
     * Sets the name of the channel to connect to the outgoing call.
     */
    public void setChannel(String channel)
    {
        this.channel = channel;
    }

    /**
     * Returns the name of the context of the extension to connect to.
     */
    public String getContext()
    {
        return context;
    }

    /**
     * Sets the name of the context of the extension to connect to.
     */
    public void setContext(String context)
    {
        this.context = context;
    }

    /**
     * Returns the the extension to connect to.
     */
    public String getExten()
    {
        return exten;
    }

    /**
     * Sets the the extension to connect to.
     */
    public void setExten(String exten)
    {
        this.exten = exten;
    }

    public Integer getReason()
    {
        return reason;
    }

    public void setReason(Integer reason)
    {
        this.reason = reason;
    }

    /**
     * Returns the unique id of the originated channel.
     * 
     * @return the unique id of the originated channel or "&lt;null&gt;" if none is available.
     */
    public String getUniqueId()
    {
        return uniqueId;
    }

    public void setUniqueId(String uniqueId)
    {
        this.uniqueId = uniqueId;
    }

    /**
     * Returns the Caller*ID Number of the originated channel.<p>
     * Available sind Asterisk 1.4.
     * 
     * @return the Caller*ID Number of the originated channel or "&lt;unknown&gt;" if none was set.
     * @since 0.3
     */
    public String getCallerIdNum()
    {
        return callerIdNum;
    }

    public void setCallerIdNum(String callerId)
    {
        this.callerIdNum = callerId;
    }
    
    // for backward compatibility only
    public void setCallerId(String callerIdNum)
    {
        this.callerIdNum = callerIdNum;
    }

    /**
     * Returns the Caller*ID Name of the originated channel.<p>
     * Available sind Asterisk 1.4.
     * 
     * @return the Caller*ID Name of the originated channel or "&lt;unknown&gt;" if none was set.
     */
    public String getCallerIdName()
    {
        return callerIdName;
    }

    public void setCallerIdName(String callerIdName)
    {
        this.callerIdName = callerIdName;
    }
}
