/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.asteriskjava.util.SocketConnectionFacade;

public class SocketConnectionFacadeImpl
implements SocketConnectionFacade {
    private final Socket socket;
    private final BufferedReader reader;
    private final BufferedWriter writer;

    public SocketConnectionFacadeImpl(String host, int port, boolean ssl, int timeout, int readTimeout) throws IOException {
        this.socket = ssl ? SSLSocketFactory.getDefault().createSocket() : SocketFactory.getDefault().createSocket();
        this.socket.setSoTimeout(readTimeout);
        this.socket.connect(new InetSocketAddress(host, port), timeout);
        InputStream inputStream = this.socket.getInputStream();
        OutputStream outputStream = this.socket.getOutputStream();
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    SocketConnectionFacadeImpl(Socket socket) throws IOException {
        this.socket = socket;
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    public String readLine() throws IOException {
        return this.reader.readLine();
    }

    public void write(String s) throws IOException {
        this.writer.write(s);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public InetAddress getRemoteAddress() {
        return this.socket.getInetAddress();
    }

    public int getRemotePort() {
        return this.socket.getPort();
    }
}

