/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx;

import org.asteriskjava.pbx.Tech;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public enum TechType implements Tech
{
    UNKNOWN,
    SIP,
    DAHDI,
    LOCAL,
    IAX,
    IAX2,
    DIALPLAN,
    CONSOLE;

    private static final Log logger;

    public static TechType getTech(String fullyQualifiedEndPoint) {
        if (!TechType.hasValidTech(fullyQualifiedEndPoint)) {
            throw new IllegalArgumentException("The provided end point '" + fullyQualifiedEndPoint + "' must contain a tech prefix. e.g. SIP/100");
        }
        String techName = fullyQualifiedEndPoint.substring(0, fullyQualifiedEndPoint.indexOf("/"));
        return TechType.valueOf(techName.toUpperCase());
    }

    public static boolean hasValidTech(String endPointName) {
        TechType tech = UNKNOWN;
        int index = endPointName.indexOf("/");
        if (index >= 1) {
            String techName = endPointName.substring(0, index);
            try {
                tech = TechType.valueOf(techName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                logger.error("Invalid tech for endpoint:" + endPointName);
            }
        }
        return tech != UNKNOWN;
    }

    public static boolean hasTech(String endPointName) {
        boolean hasTech = false;
        int index = endPointName.indexOf("/");
        if (index != -1) {
            hasTech = true;
        }
        return hasTech;
    }

    static {
        logger = LogFactory.getLog(TechType.class);
    }
}

