/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.activity;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.asteriskjava.pbx.ActivityCallback;
import org.asteriskjava.pbx.AsteriskSettings;
import org.asteriskjava.pbx.Call;
import org.asteriskjava.pbx.CallImpl;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.ListenerPriority;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.activities.SplitActivity;
import org.asteriskjava.pbx.agi.AgiChannelActivityHold;
import org.asteriskjava.pbx.asterisk.wrap.actions.RedirectAction;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.internal.activity.ActivityHelper;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.pbx.internal.core.ChannelProxy;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class SplitActivityImpl
extends ActivityHelper<SplitActivity>
implements SplitActivity {
    private static final Log logger = LogFactory.getLog(SplitActivityImpl.class);
    private Call _callToSplit;
    private Channel channel1;
    private Channel channel2;
    private Call _lhsCall;
    private Call _rhsCall;

    public SplitActivityImpl(Call callToSplit, ActivityCallback<SplitActivity> listener) {
        super("SplitActivity", listener);
        this._callToSplit = callToSplit;
        List<Channel> tmp = callToSplit.getChannels();
        if (tmp.size() > 1) {
            this.channel1 = tmp.get(0);
            this.channel2 = tmp.get(1);
        }
        this.startActivity(true);
    }

    @Override
    public boolean doActivity() throws PBXException {
        logger.debug("*******************************************************************************");
        logger.info("***********                    begin split               ****************");
        logger.info("***********            " + this.channel1 + "                 ****************");
        logger.debug("***********            " + this.channel2 + "                 ****************");
        logger.debug("*******************************************************************************");
        boolean success = false;
        if (this.channel2 != null && (success = this.splitTwo())) {
            this._lhsCall = ((CallImpl)this._callToSplit).split(this.channel1);
            this._rhsCall = ((CallImpl)this._callToSplit).split(this.channel2);
        }
        return success;
    }

    @Override
    public HashSet<Class<? extends ManagerEvent>> requiredEvents() {
        HashSet<Class<? extends ManagerEvent>> required = new HashSet<Class<? extends ManagerEvent>>();
        return required;
    }

    @Override
    public synchronized void onManagerEvent(ManagerEvent event) {
    }

    @Override
    public ListenerPriority getPriority() {
        return ListenerPriority.NORMAL;
    }

    @Override
    public Call getLHSCall() {
        return this._lhsCall;
    }

    @Override
    public Call getRHSCall() {
        return this._rhsCall;
    }

    private boolean splitTwo() throws PBXException {
        AsteriskSettings profile = PBXFactory.getActiveProfile();
        AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
        if (this.channel1 == this.channel2) {
            throw new NullPointerException("channel1 is the same as channel2. if I let this happen, asterisk will core dump :)");
        }
        LinkedList<Channel> channels = new LinkedList<Channel>();
        channels.add(this.channel1);
        channels.add(this.channel2);
        if (!pbx.waitForChannelsToQuiescent(channels, 3000L)) {
            logger.error(this.callSite, this.callSite);
            throw new PBXException("Channel: " + this.channel1 + " or " + this.channel2 + " cannot be split as they are still in transition.");
        }
        AgiChannelActivityHold agi1 = new AgiChannelActivityHold();
        AgiChannelActivityHold agi2 = new AgiChannelActivityHold();
        pbx.setVariable(this.channel1, "proxyId", "" + ((ChannelProxy)this.channel1).getIdentity());
        pbx.setVariable(this.channel2, "proxyId", "" + ((ChannelProxy)this.channel2).getIdentity());
        this.channel1.setCurrentActivityAction(agi1);
        this.channel2.setCurrentActivityAction(agi2);
        String agiExten = profile.getAgiExtension();
        String agiContext = profile.getManagementContext();
        logger.debug("splitTwo channel lhs:" + this.channel1 + " to " + agiExten + " in context " + agiContext + " from " + this._callToSplit);
        EndPoint extensionAgi = pbx.getExtensionAgi();
        RedirectAction redirect = new RedirectAction(this.channel1, agiContext, extensionAgi, 1);
        redirect.setExtraChannel(this.channel2);
        redirect.setExtraContext(agiContext);
        redirect.setExtraExten(extensionAgi);
        redirect.setExtraPriority(1);
        boolean ret = false;
        try {
            pbx.sendAction(redirect, 1000);
            double ctr = 0.0;
            while (!(agi1.hasCallReachedAgi() && agi2.hasCallReachedAgi() || !(ctr < 10.0))) {
                Thread.sleep(100L);
                ctr += 0.1;
                if (!agi1.hasCallReachedAgi()) {
                    logger.info("Waiting on (agi1) " + this.channel1);
                }
                if (agi2.hasCallReachedAgi()) continue;
                logger.info("Waiting on (agi2) " + this.channel2);
            }
            ret = agi1.hasCallReachedAgi() && agi2.hasCallReachedAgi();
        }
        catch (Exception e) {
            logger.error(e, e);
        }
        return ret;
    }
}

