/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.BridgeEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.LinkEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.UnlinkEvent;
import org.asteriskjava.pbx.internal.core.CoherentEventFactory;
import org.asteriskjava.pbx.internal.core.FilteredManagerListener;
import org.asteriskjava.pbx.internal.core.FilteredManagerListenerWrapper;
import org.asteriskjava.pbx.internal.core.ListenerManager;
import org.asteriskjava.pbx.internal.eventQueue.EventLifeMonitor;
import org.asteriskjava.pbx.util.LogTime;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

class CoherentManagerEventQueue
implements ManagerEventListener,
Runnable {
    private static final Log logger = LogFactory.getLog(CoherentManagerEventQueue.class);
    private final ListenerManager listeners = new ListenerManager();
    private boolean _stop = false;
    private final Thread _th;
    private final BlockingQueue<EventLifeMonitor<ManagerEvent>> _eventQueue = new LinkedBlockingQueue<EventLifeMonitor<ManagerEvent>>();
    private int _queueMaxSize;
    private long _queueSum;
    private long _queueCount;
    private HashSet<Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>> globalEvents = new HashSet();
    private final ExecutorService executors = Executors.newFixedThreadPool(1);

    public CoherentManagerEventQueue(String name, ManagerConnection connection) {
        connection.addEventListener(this);
        this._th = new Thread(this);
        this._th.setName("EventQueue: " + name);
        this._th.setDaemon(true);
        this._th.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onManagerEvent(ManagerEvent event) {
        boolean wanted = false;
        HashSet<Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>> hashSet = this.globalEvents;
        synchronized (hashSet) {
            Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent> shadowEvent = CoherentEventFactory.getShadowEvent(event);
            if (this.globalEvents.contains(shadowEvent)) {
                wanted = true;
            }
        }
        if (wanted) {
            this._eventQueue.add(new EventLifeMonitor<ManagerEvent>(event));
            int queueSize = this._eventQueue.size();
            if (this._queueMaxSize < queueSize) {
                this._queueMaxSize = queueSize;
            }
            this._queueSum += (long)queueSize;
            ++this._queueCount;
            if (logger.isDebugEnabled() && (long)this._eventQueue.size() > ((long)this._queueMaxSize + this._queueSum / this._queueCount) / 2L) {
                logger.debug("queue gtr max avg: size=" + queueSize + " max:" + this._queueMaxSize + " avg:" + this._queueSum / this._queueCount);
            }
        }
    }

    @Override
    public void run() {
        while (!this._stop) {
            try {
                EventLifeMonitor<ManagerEvent> elm = this._eventQueue.poll(2L, TimeUnit.SECONDS);
                if (elm == null) continue;
                if (elm.getEvent().getClass() == PoisonQueueEvent.class) break;
                org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent iEvent = CoherentEventFactory.build(elm.getEvent());
                if (iEvent == null) continue;
                this.dispatchEvent(iEvent);
                elm.assessAge();
            }
            catch (Exception e) {
                if (this._stop) continue;
                logger.error(e, e);
            }
        }
    }

    public void stop() {
        this._stop = true;
        try {
            this._eventQueue.put(new EventLifeMonitor<PoisonQueueEvent>(new PoisonQueueEvent()));
        }
        catch (InterruptedException e) {
            logger.error(e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent event) {
        List<FilteredManagerListenerWrapper> listenerCopy;
        if (logger.isDebugEnabled()) {
            logger.debug("dispatch=" + event.toString());
        }
        ListenerManager listenerManager = this.listeners;
        synchronized (listenerManager) {
            listenerCopy = this.listeners.getCopyAsList();
        }
        try {
            LogTime totalTime = new LogTime();
            CountDownLatch latch = new CountDownLatch(listenerCopy.size());
            for (FilteredManagerListenerWrapper filter : listenerCopy) {
                if (filter.requiredEvents.contains(event.getClass())) {
                    this.dispatchEventOnThread(event, filter, latch);
                    continue;
                }
                latch.countDown();
            }
            latch.await();
            if (totalTime.timeTaken() > 500L) {
                logger.warn("Too long to process event " + event + " time taken: " + totalTime.timeTaken());
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    private void dispatchEventOnThread(final org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent event, final FilteredManagerListenerWrapper filter, final CountDownLatch latch) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try {
                    LogTime time = new LogTime();
                    filter._listener.onManagerEvent(event);
                    if (time.timeTaken() > 500L) {
                        logger.warn("ManagerListener :" + filter._listener.getName() + " is taken too long to process event " + event + " time taken: " + time.timeTaken());
                    }
                }
                catch (Exception e) {
                    logger.error(e, e);
                }
                finally {
                    latch.countDown();
                }
            }
        };
        this.executors.execute(runner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FilteredManagerListener<org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent> listener) {
        ListenerManager listenerManager = this.listeners;
        synchronized (listenerManager) {
            this.listeners.addListener(listener);
            HashSet<Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>> hashSet = this.globalEvents;
            synchronized (hashSet) {
                Collection<Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>> expandEvents = this.expandEvents(listener.requiredEvents());
                this.globalEvents.addAll(expandEvents);
            }
        }
        logger.debug("listener  added " + listener);
    }

    Collection<Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>> expandEvents(Collection<Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>> events) {
        HashSet<Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>> requiredEvents = new HashSet<Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>>();
        for (Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent> event : events) {
            requiredEvents.add(event);
            if (!event.equals(BridgeEvent.class)) continue;
            requiredEvents.add(UnlinkEvent.class);
            requiredEvents.add(LinkEvent.class);
        }
        return requiredEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(FilteredManagerListener<org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent> melf) {
        if (melf != null) {
            ListenerManager listenerManager = this.listeners;
            synchronized (listenerManager) {
                this.listeners.removeListener(melf);
                HashSet<Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>> hashSet = this.globalEvents;
                synchronized (hashSet) {
                    this.globalEvents.clear();
                    Iterator<FilteredManagerListenerWrapper> itr = this.listeners.iterator();
                    while (itr.hasNext()) {
                        FilteredManagerListenerWrapper readdContainer = itr.next();
                        this.globalEvents.addAll(this.expandEvents(readdContainer._listener.requiredEvents()));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferListeners(CoherentManagerEventQueue eventQueue) {
        ListenerManager listenerManager = this.listeners;
        synchronized (listenerManager) {
            ListenerManager listenerManager2 = eventQueue.listeners;
            synchronized (listenerManager2) {
                Iterator<FilteredManagerListenerWrapper> itr = eventQueue.listeners.iterator();
                while (itr.hasNext()) {
                    FilteredManagerListenerWrapper listener = itr.next();
                    this.addListener(listener._listener);
                }
                eventQueue.listeners.clear();
            }
        }
    }

    class PoisonQueueEvent
    extends ManagerEvent {
        private static final long serialVersionUID = 1L;

        public PoisonQueueEvent() {
            super("PoisonQueueEvent");
        }
    }
}

