/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util.internal.streamreader;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicReference;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.internal.streamreader.FastScanner;

public class FastScannerNl
implements FastScanner {
    private static final Log logger = LogFactory.getLog(FastScannerNl.class);
    private static final int BUFFER_SIZE = 8192;
    private AtomicReference<Readable> readableReference = new AtomicReference();
    protected char nlChar = (char)10;
    protected StringBuilder result = new StringBuilder(80);
    protected CharBuffer cbuf = CharBuffer.allocate(8192);
    protected int end = 0;
    protected int start = 0;
    private boolean closed = false;
    protected final Object sync = new Object();
    private boolean isFirst = true;
    File logfile;
    private BufferedWriter writer;

    public FastScannerNl(Readable reader) {
        this.readableReference.set(reader);
    }

    @Override
    public String next() throws IOException {
        int bytes = 0;
        String line = this.getLine(false);
        if (line == null) {
            Readable readable = this.readableReference.get();
            while (readable != null && (bytes = readable.read(this.cbuf)) > -1) {
                this.cbuf.position(0);
                this.end = bytes;
                line = this.getLine(bytes >= 0);
                if (line == null) continue;
                if (!this.isFirst || line.length() != 0) break;
                line = this.getLine(bytes >= 0);
                break;
            }
        }
        this.isFirst = false;
        if (line == null) {
            String tmp = this.result.toString();
            this.result.setLength(0);
            if (this.readableReference.get() == null && tmp.length() == 0) {
                return null;
            }
            if (bytes == -1 && tmp.length() == 0) {
                return null;
            }
            return tmp;
        }
        return line;
    }

    protected String getLine(boolean endOfLine) {
        for (int i = this.start; i < this.end; ++i) {
            if (this.cbuf.get(i) != this.nlChar) continue;
            if (i > this.start) {
                this.result.append(this.cbuf.subSequence(this.start, this.start + (i - this.start)));
            }
            this.start = i + 1;
            String tmp = this.result.toString();
            this.result.setLength(0);
            return tmp;
        }
        if (this.end >= this.start) {
            this.result.append(this.cbuf.subSequence(this.start, this.start + (this.end - this.start))).toString();
            this.start = 0;
            this.end = 0;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.sync;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            if (this.readableReference.get() instanceof Closeable) {
                try {
                    ((Closeable)((Object)this.readableReference.get())).close();
                }
                catch (IOException ioe) {
                    logger.error(ioe, ioe);
                }
            }
            this.readableReference.set(null);
            this.closed = true;
        }
    }

    private void createFileWriter() {
        try {
            this.logfile = File.createTempFile(this.getClass().getSimpleName(), "txt");
            this.writer = Files.newBufferedWriter(this.logfile.toPath(), Charset.defaultCharset(), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeToFile(int bytes) throws IOException {
        String lines = new StringBuffer().append(this.cbuf, 0, bytes).toString();
        this.writer.append(lines, 0, bytes);
    }

    private void closeFileWriter() throws IOException {
        this.writer.flush();
        this.writer.close();
    }
}

