/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.BinaryBuilderValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LargeStringBuilderValue;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnsetStringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.ValueType;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringBuilderValue
extends StringValue {
    public static final StringBuilderValue EMPTY = new StringBuilderValue("");
    private static final StringBuilderValue[] CHAR_STRINGS = new StringBuilderValue[256];
    protected char[] _buffer;
    protected int _length;
    protected boolean _isCopy;
    private int _hashCode;
    protected String _value;

    public StringBuilderValue() {
        this._buffer = new char[128];
    }

    public StringBuilderValue(int capacity) {
        if (capacity < 64) {
            capacity = 64;
        }
        this._buffer = new char[capacity];
    }

    public StringBuilderValue(char[] buffer, int offset, int length) {
        this._buffer = new char[length];
        this._length = length;
        System.arraycopy(buffer, offset, this._buffer, 0, length);
    }

    public StringBuilderValue(byte[] buffer, int offset, int length) {
        this._buffer = new char[length];
        this._length = length;
        for (int i = offset; i < length; ++i) {
            this._buffer[i] = (char)buffer[i];
        }
    }

    public StringBuilderValue(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public StringBuilderValue(Byte[] buffer) {
        int length = buffer.length;
        this._buffer = new char[length];
        this._length = length;
        for (int i = 0; i < length; ++i) {
            this._buffer[i] = (char)buffer[i].byteValue();
        }
    }

    public StringBuilderValue(Character[] buffer) {
        int length = buffer.length;
        this._buffer = new char[length];
        this._length = length;
        for (int i = 0; i < length; ++i) {
            this._buffer[i] = buffer[i].charValue();
        }
    }

    public StringBuilderValue(char ch) {
        this._buffer = new char[1];
        this._length = 1;
        this._buffer[0] = ch;
    }

    public StringBuilderValue(String s) {
        int len = s.length();
        this._buffer = new char[len];
        this._length = len;
        s.getChars(0, len, this._buffer, 0);
    }

    public StringBuilderValue(char[] s) {
        int len = s.length;
        this._buffer = new char[len];
        this._length = len;
        System.arraycopy(s, 0, this._buffer, 0, len);
    }

    public StringBuilderValue(char[] s, Value v1) {
        int len = s.length;
        this._buffer = len < 128 ? new char[128] : new char[len + 32];
        this._length = len;
        System.arraycopy(s, 0, this._buffer, 0, len);
        v1.appendTo(this);
    }

    public StringBuilderValue(Value v1) {
        this._buffer = new char[128];
        v1.appendTo(this);
    }

    public StringBuilderValue(Value v1, Value v2) {
        this._buffer = new char[128];
        v1.appendTo(this);
        v2.appendTo(this);
    }

    public StringBuilderValue(Value v1, Value v2, Value v3) {
        this._buffer = new char[128];
        v1.appendTo(this);
        v2.appendTo(this);
        v3.appendTo(this);
    }

    public static StringValue create(char value) {
        if (value < CHAR_STRINGS.length) {
            return CHAR_STRINGS[value];
        }
        return new StringBuilderValue(value);
    }

    public static Value create(String value) {
        if (value == null) {
            return NullValue.NULL;
        }
        if (value.length() == 0) {
            return EMPTY;
        }
        return new StringBuilderValue(value);
    }

    public String getValue() {
        return this.toString();
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public ValueType getValueType() {
        return UnicodeBuilderValue.getValueType(this._buffer, 0, this._length);
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isPHP5String() {
        return true;
    }

    @Override
    public boolean toBoolean() {
        if (this._length == 0) {
            return false;
        }
        return this._length != 1 || this._buffer[0] != '0';
    }

    @Override
    public long toLong() {
        return StringBuilderValue.parseLong(this._buffer, 0, this._length);
    }

    @Override
    public double toDouble() {
        return UnicodeBuilderValue.toDouble(this._buffer, 0, this._length);
    }

    @Override
    public InputStream toInputStream() {
        return new BuilderInputStream();
    }

    @Override
    public String toString() {
        if (this._value == null) {
            this._value = new String(this._buffer, 0, this._length);
        }
        return this._value;
    }

    @Override
    public StringValue toBinaryValue(Env env) {
        return this;
    }

    @Override
    public StringValue toBinaryValue(Env env, String charset) {
        return this;
    }

    @Override
    public StringValue toUnicodeValue() {
        return this;
    }

    @Override
    public StringValue toUnicodeValue(Env env) {
        return this.toUnicodeValue();
    }

    @Override
    public StringValue toUnicodeValue(Env env, String charset) {
        return this.toUnicodeValue();
    }

    @Override
    public Object toJavaObject() {
        if (this._value == null) {
            this._value = new String(this._buffer, 0, this._length);
        }
        return this._value;
    }

    @Override
    public final boolean isEmpty() {
        return this._length == 0 || this._length == 1 && this._buffer[0] == '0';
    }

    @Override
    public void writeTo(OutputStream os) {
        try {
            int len = this._length;
            for (int i = 0; i < len; ++i) {
                os.write(this._buffer[i]);
            }
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    @Override
    public StringValue appendTo(StringBuilderValue bb) {
        bb.append(this._buffer, 0, this._length);
        return bb;
    }

    @Override
    public StringValue appendTo(UnicodeBuilderValue bb) {
        bb.append(this._buffer, 0, this._length);
        return bb;
    }

    @Override
    public StringValue appendTo(LargeStringBuilderValue bb) {
        bb.append(this._buffer, 0, this._length);
        return bb;
    }

    @Override
    public StringValue appendTo(BinaryBuilderValue bb) {
        bb.append(this._buffer, 0, this._length);
        return bb;
    }

    @Override
    public Value toKey() {
        char[] buffer = this._buffer;
        int len = this._length;
        if (len == 0) {
            return this;
        }
        int sign = 1;
        long value = 0L;
        int i = 0;
        char ch = buffer[i];
        if (ch == '-') {
            sign = -1;
            ++i;
        }
        while (i < len) {
            ch = buffer[i];
            if ('0' > ch || ch > '9') {
                return this;
            }
            value = 10L * value + (long)ch - 48L;
            ++i;
        }
        return new LongValue((long)sign * value);
    }

    @Override
    public byte[] toBytes() {
        byte[] bytes = new byte[this._length];
        for (int i = this._length - 1; i >= 0; --i) {
            bytes[i] = (byte)this._buffer[i];
        }
        return bytes;
    }

    @Override
    public Value get(Value key) {
        return this.charValueAt(key.toLong());
    }

    @Override
    public Value getRef(Value key) {
        return this.charValueAt(key.toLong());
    }

    @Override
    public Value put(Value index, Value value) {
        this.setCharValueAt(index.toLong(), value.toString());
        return value;
    }

    @Override
    public Value append(Value index, Value value) {
        return this.setCharValueAt(index.toLong(), value.toString());
    }

    @Override
    public final int length() {
        return this._length;
    }

    @Override
    public final char charAt(int index) {
        return this._buffer[index];
    }

    @Override
    public Value charValueAt(long index) {
        int len = this._length;
        if (index < 0L || (long)len <= index) {
            return UnsetStringValue.UNSET;
        }
        char ch = this._buffer[(int)index];
        if (ch < CHAR_STRINGS.length) {
            return CHAR_STRINGS[ch];
        }
        return new StringBuilderValue(ch);
    }

    @Override
    public Value setCharValueAt(long indexL, String value) {
        int len = this._length;
        if (indexL < 0L) {
            return this;
        }
        int index = (int)indexL;
        StringBuilderValue sb = (StringBuilderValue)this.toStringBuilder();
        int padLen = index - len;
        if (padLen > 0) {
            for (int i = 0; i <= padLen; ++i) {
                sb.append(' ');
            }
        }
        sb._buffer[index] = value.length() == 0 ? (char)'\u0000' : value.charAt(0);
        return sb;
    }

    @Override
    public int indexOf(char match) {
        int length = this._length;
        char[] buffer = this._buffer;
        for (int head = 0; head < length; ++head) {
            if (buffer[head] != match) continue;
            return head;
        }
        return -1;
    }

    @Override
    public int indexOf(char match, int head) {
        int length = this._length;
        char[] buffer = this._buffer;
        while (head < length) {
            if (buffer[head] == match) {
                return head;
            }
            ++head;
        }
        return -1;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (end <= start) {
            return EMPTY;
        }
        return new StringBuilderValue(this._buffer, start, end - start);
    }

    @Override
    public StringValue toLowerCase() {
        int length = this._length;
        StringBuilderValue string = new StringBuilderValue(length);
        char[] srcBuffer = this._buffer;
        char[] dstBuffer = string._buffer;
        for (int i = 0; i < length; ++i) {
            char ch = srcBuffer[i];
            dstBuffer[i] = 'A' <= ch && ch <= 'Z' ? (char)(ch + 97 - 65) : ch;
        }
        string._length = length;
        return string;
    }

    @Override
    public StringValue toUpperCase() {
        int length = this._length;
        StringBuilderValue string = new StringBuilderValue(this._length);
        char[] srcBuffer = this._buffer;
        char[] dstBuffer = string._buffer;
        for (int i = 0; i < length; ++i) {
            char ch = srcBuffer[i];
            dstBuffer[i] = 'a' <= ch && ch <= 'z' ? (char)(ch + 65 - 97) : ch;
        }
        string._length = length;
        return string;
    }

    @Override
    public boolean regionMatches(int offset, char[] mBuffer, int mOffset, int mLength) {
        int length = this._length;
        if (length < offset + mLength) {
            return false;
        }
        char[] buffer = this._buffer;
        for (int i = 0; i < mLength; ++i) {
            if (buffer[offset + i] == mBuffer[mOffset + i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean regionMatchesIgnoreCase(int offset, char[] mBuffer, int mOffset, int mLength) {
        int length = this._length;
        if (length < offset + mLength) {
            return false;
        }
        char[] buffer = this._buffer;
        for (int i = 0; i < mLength; ++i) {
            char a = buffer[offset + i];
            char b = mBuffer[mOffset + i];
            if ('A' <= a && a <= 'Z') {
                a = (char)(a + 32);
            }
            if ('A' <= b && b <= 'Z') {
                b = (char)(b + 32);
            }
            if (a == b) continue;
            return false;
        }
        return true;
    }

    @Override
    public StringValue createStringBuilder() {
        return new StringBuilderValue();
    }

    @Override
    public StringValue createStringBuilder(int length) {
        return new StringBuilderValue(length);
    }

    @Override
    public StringValue toStringBuilder() {
        return new StringBuilderValue(this._buffer, 0, this._length);
    }

    @Override
    public StringValue toStringBuilder(Env env) {
        int length = this._length + 64 & 0xFFFFFFE0;
        StringBuilderValue v = new StringBuilderValue(length);
        System.arraycopy(this._buffer, 0, v._buffer, 0, this._length);
        v._length = this._length;
        return v;
    }

    @Override
    public StringValue toStringBuilder(Env env, Value value) {
        int length = this._length;
        if (value instanceof StringValue) {
            length += ((StringValue)value).length();
        }
        length = length + 64 & 0xFFFFFFE0;
        StringBuilderValue v = new StringBuilderValue(length);
        System.arraycopy(this._buffer, 0, v._buffer, 0, this._length);
        v._length = this._length;
        value.appendTo(v);
        return v;
    }

    @Override
    public final StringValue append(String s) {
        int sublen = s.length();
        if (this._buffer.length < this._length + sublen) {
            this.ensureCapacity(this._length + sublen);
        }
        for (int i = 0; i < sublen; ++i) {
            this._buffer[this._length++] = s.charAt(i);
        }
        return this;
    }

    @Override
    public final StringValue append(String s, int start, int end) {
        int sublen = end - start;
        if (this._buffer.length < this._length + sublen) {
            this.ensureCapacity(this._length + sublen);
        }
        char[] buffer = this._buffer;
        int length = this._length;
        while (start < end) {
            buffer[length++] = s.charAt(start);
            ++start;
        }
        this._length = length;
        return this;
    }

    @Override
    public final StringValue append(char ch) {
        if (this._buffer.length < this._length + 1) {
            this.ensureCapacity(this._length + 1);
        }
        this._buffer[this._length++] = ch;
        return this;
    }

    @Override
    public final StringValue append(char[] buf, int offset, int length) {
        int end = this._length + length;
        if (this._buffer.length < end) {
            this.ensureCapacity(end);
        }
        char[] buffer = this._buffer;
        int bufferLength = this._length;
        while (--length >= 0) {
            buffer[bufferLength + length] = buf[offset + length];
        }
        this._length = end;
        return this;
    }

    @Override
    public final StringValue appendUnicode(char[] buf, int offset, int length) {
        if (this._buffer.length < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        char[] buffer = this._buffer;
        int bufferLength = this._length;
        while (length > 0) {
            buffer[bufferLength++] = buf[offset++];
            --length;
        }
        this._buffer = buffer;
        this._length = bufferLength;
        return this;
    }

    @Override
    public final StringValue append(char[] buf) {
        int length = buf.length;
        if (this._buffer.length < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        char[] buffer = this._buffer;
        int bufferLength = this._length;
        this._length = bufferLength + length;
        --length;
        while (length >= 0) {
            buffer[bufferLength + length] = buf[length];
            --length;
        }
        this._buffer = buffer;
        return this;
    }

    @Override
    public final StringValue appendUnicode(char[] buf) {
        int length = buf.length;
        if (this._buffer.length < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        char[] buffer = this._buffer;
        int bufferLength = this._length;
        this._length = bufferLength + length;
        --length;
        while (length >= 0) {
            buffer[bufferLength + length] = buf[length];
            --length;
        }
        this._buffer = buffer;
        return this;
    }

    @Override
    public final StringValue append(CharSequence buf, int head, int tail) {
        int length = tail - head;
        if (this._buffer.length < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        if (buf instanceof StringBuilderValue) {
            StringBuilderValue sb = (StringBuilderValue)buf;
            System.arraycopy(sb._buffer, head, this._buffer, this._length, tail - head);
            this._length += tail - head;
            return this;
        }
        char[] buffer = this._buffer;
        int bufferLength = this._length;
        while (head < tail) {
            buffer[bufferLength++] = buf.charAt(head);
            ++head;
        }
        this._length = bufferLength;
        return this;
    }

    public final StringValue append(StringBuilderValue sb, int head, int tail) {
        int length = tail - head;
        if (this._buffer.length < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        System.arraycopy(sb._buffer, head, this._buffer, this._length, tail - head);
        this._length += tail - head;
        return this;
    }

    @Override
    public final StringValue append(Value v) {
        v.appendTo(this);
        return this;
    }

    @Override
    public int indexOf(CharSequence match, int head) {
        int length = this.length();
        int matchLength = match.length();
        if (matchLength <= 0) {
            return -1;
        }
        if (head < 0) {
            return -1;
        }
        int end = length - matchLength;
        char first = match.charAt(0);
        while (head <= end) {
            block6: {
                if (this._buffer[head] == first) {
                    for (int i = 1; i < matchLength; ++i) {
                        if (this._buffer[head + i] == match.charAt(i)) {
                            continue;
                        }
                        break block6;
                    }
                    return head;
                }
            }
            ++head;
        }
        return -1;
    }

    @Override
    public StringValue appendUnicode(Value v) {
        v.appendTo(this);
        return this;
    }

    @Override
    public StringValue appendUnicode(Value v1, Value v2) {
        v1.appendTo(this);
        v2.appendTo(this);
        return this;
    }

    @Override
    public StringValue append(byte[] buf, int offset, int length) {
        int end = this._length + length;
        if (this._buffer.length < end) {
            this.ensureCapacity(end);
        }
        char[] charBuffer = this._buffer;
        int charLength = this._length;
        for (int i = length - 1; i >= 0; --i) {
            charBuffer[charLength + i] = (char)(buf[offset + i] & 0xFF);
        }
        this._length = end;
        return this;
    }

    @Override
    public final StringValue append(byte[] buf) {
        return this.append(buf, 0, buf.length);
    }

    @Override
    public final StringValue appendByte(int v) {
        int length = this._length + 1;
        if (this._buffer.length < length) {
            this.ensureCapacity(length);
        }
        this._buffer[this._length++] = (char)v;
        return this;
    }

    @Override
    public final StringValue append(boolean v) {
        return this.append(v ? "true" : "false");
    }

    @Override
    public StringValue append(long v) {
        return this.append(String.valueOf(v));
    }

    @Override
    public StringValue append(double v) {
        return this.append(String.valueOf(v));
    }

    @Override
    public StringValue appendBytes(String s) {
        int sublen = s.length();
        if (this._buffer.length < this._length + sublen) {
            this.ensureCapacity(this._length + sublen);
        }
        for (int i = 0; i < sublen; ++i) {
            this._buffer[this._length++] = s.charAt(i);
        }
        return this;
    }

    @Override
    public final StringValue appendBytes(byte[] bytes, int offset, int end) {
        int length = this._length + end - offset;
        if (this._buffer.length < length) {
            this.ensureCapacity(length);
        }
        for (int i = offset; i < end; ++i) {
            this._buffer[this._length++] = (char)bytes[i];
        }
        return this;
    }

    @Override
    public StringValue append(Reader reader, long length) throws IOException {
        int sublen = (int)Math.min(8192L, length);
        try {
            while (length > 0L) {
                this.ensureAppendCapacity(sublen);
                int count = reader.read(this._buffer, this._length, sublen);
                if (count > 0) {
                    length -= (long)count;
                    this._length += count;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        return this;
    }

    public char[] getBuffer() {
        return this._buffer;
    }

    public int getOffset() {
        return this._length;
    }

    public void setOffset(int offset) {
        this._length = offset;
    }

    public int getLength() {
        return this._buffer.length;
    }

    @Override
    public void print(Env env) {
        env.print(this._buffer, 0, this._length);
    }

    @Override
    public void print(Env env, WriteStream out) {
        try {
            out.print(this._buffer, 0, this._length);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    @Override
    public void serialize(Env env, StringBuilder sb) {
        sb.append("s:");
        sb.append(this._length);
        sb.append(":\"");
        sb.append(this.toString());
        sb.append("\";");
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        int length = this.length();
        sb.append("binary(");
        sb.append(length);
        sb.append(") \"");
        int appendLength = length > 256 ? 256 : length;
        for (int i = 0; i < appendLength; ++i) {
            sb.append(this.charAt(i));
        }
        if (length > 256) {
            sb.append(" ...");
        }
        sb.append('\"');
        return sb.toString();
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        int length = this.length();
        if (length < 0) {
            length = 0;
        }
        out.print("string(");
        out.print(length);
        out.print(") \"");
        for (int i = 0; i < length; ++i) {
            char ch = this.charAt(i);
            out.print(ch);
        }
        out.print("\"");
    }

    public OutputStream getOutputStream() {
        return new BuilderOutputStream();
    }

    @Override
    public void ensureAppendCapacity(int newCapacity) {
        this.ensureCapacity(this._length + newCapacity);
    }

    protected void ensureCapacity(int newCapacity) {
        if (newCapacity <= this._buffer.length) {
            return;
        }
        newCapacity = newCapacity < 4096 ? 4 * newCapacity : (newCapacity += 4096);
        assert (newCapacity > this._buffer.length) : "cannot set new capacity to " + newCapacity;
        char[] buffer = new char[newCapacity];
        System.arraycopy(this._buffer, 0, buffer, 0, this._length);
        this._buffer = buffer;
    }

    @Override
    public int hashCode() {
        int hash = this._hashCode;
        if (hash != 0) {
            return hash;
        }
        hash = 37;
        int length = this._length;
        char[] buffer = this._buffer;
        if (length > 256) {
            int i;
            for (i = 127; i >= 0; --i) {
                hash = 65521 * hash + buffer[i];
            }
            for (i = length - 128; i < length; ++i) {
                hash = 65521 * hash + buffer[i];
            }
            this._hashCode = hash;
            return hash;
        }
        for (int i = length - 1; i >= 0; --i) {
            hash = 65521 * hash + buffer[i];
        }
        this._hashCode = hash;
        return hash;
    }

    @Override
    public boolean eq(Value rValue) {
        ValueType typeB = rValue.getValueType();
        if (typeB.isNumber()) {
            double r;
            double l = this.toDouble();
            return l == (r = rValue.toDouble());
        }
        if (typeB.isBoolean()) {
            return this.toBoolean() == rValue.toBoolean();
        }
        ValueType typeA = this.getValueType();
        if (typeA.isNumberCmp() && typeB.isNumberCmp()) {
            double r;
            double l = this.toDouble();
            return l == (r = rValue.toDouble());
        }
        if ((rValue = rValue.toValue()) instanceof StringBuilderValue) {
            StringBuilderValue value = (StringBuilderValue)rValue;
            int length = this._length;
            if (length != value._length) {
                return false;
            }
            char[] bufferA = this._buffer;
            char[] bufferB = value._buffer;
            for (int i = length - 1; i >= 0; --i) {
                if (bufferA[i] == bufferB[i]) continue;
                return false;
            }
            return true;
        }
        return this.toString().equals(rValue.toString());
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof StringBuilderValue) {
            StringBuilderValue value = (StringBuilderValue)o;
            int length = this._length;
            if (length != value._length) {
                return false;
            }
            char[] bufferA = this._buffer;
            char[] bufferB = value._buffer;
            for (int i = length - 1; i >= 0; --i) {
                if (bufferA[i] == bufferB[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean eql(Value o) {
        if ((o = o.toValue()) instanceof StringBuilderValue) {
            StringBuilderValue value = (StringBuilderValue)o;
            int length = this._length;
            if (length != value._length) {
                return false;
            }
            char[] bufferA = this._buffer;
            char[] bufferB = value._buffer;
            for (int i = length - 1; i >= 0; --i) {
                if (bufferA[i] == bufferB[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this._length);
        for (int i = 0; i < this._length; ++i) {
            out.write(this._buffer[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this._length = in.readInt();
        this._buffer = new char[this._length];
        for (int i = 0; i < this._length; ++i) {
            this._buffer[i] = (char)in.read();
        }
    }

    static {
        for (int i = 0; i < CHAR_STRINGS.length; ++i) {
            StringBuilderValue.CHAR_STRINGS[i] = new StringBuilderValue((char)i);
        }
    }

    class BuilderOutputStream
    extends OutputStream {
        BuilderOutputStream() {
        }

        public void write(int ch) {
            StringBuilderValue.this.append(ch);
        }

        public void write(byte[] buffer, int offset, int length) {
            StringBuilderValue.this.append(buffer, offset, length);
        }
    }

    class BuilderInputStream
    extends InputStream {
        private int _index;

        BuilderInputStream() {
        }

        public int read() {
            if (this._index < StringBuilderValue.this._length) {
                return StringBuilderValue.this._buffer[this._index++] & 0xFF;
            }
            return -1;
        }

        public int read(byte[] buffer, int offset, int length) {
            int sublen = StringBuilderValue.this._length - this._index;
            if (length < sublen) {
                sublen = length;
            }
            if (sublen <= 0) {
                return -1;
            }
            for (int i = 0; i < sublen; ++i) {
                buffer[offset + i] = (byte)StringBuilderValue.this._buffer[this._index + i];
            }
            this._index += sublen;
            return sublen;
        }
    }

    class BinaryInputStream
    extends InputStream {
        private int _offset;

        BinaryInputStream() {
        }

        public int read() {
            if (this._offset < StringBuilderValue.this._length) {
                return StringBuilderValue.this._buffer[this._offset++];
            }
            return -1;
        }

        public int read(byte[] buffer, int offset, int length) {
            int sublen = StringBuilderValue.this._length - this._offset;
            if (length < sublen) {
                sublen = length;
            }
            if (sublen <= 0) {
                return -1;
            }
            System.arraycopy(StringBuilderValue.this._buffer, this._offset, buffer, offset, sublen);
            this._offset += sublen;
            return sublen;
        }
    }
}

