/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.Quercus;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnsetUnicodeValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.ValueType;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.i18n.Decoder;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StringValue
extends Value
implements CharSequence {
    public static final StringValue EMPTY = new StringBuilderValue("");
    private static final StringValue[] CHAR_STRINGS = new StringValue[256];
    protected static final int IS_STRING = 0;
    protected static final int IS_LONG = 1;
    protected static final int IS_DOUBLE = 2;

    public abstract StringValue createStringBuilder();

    public abstract StringValue createStringBuilder(int var1);

    public static Value create(String value) {
        if (value == null) {
            return NullValue.NULL;
        }
        return new StringBuilderValue(value);
    }

    public static StringValue create(char value) {
        if (value < CHAR_STRINGS.length) {
            return CHAR_STRINGS[value];
        }
        return new StringBuilderValue(String.valueOf(value));
    }

    public static Value create(Object value) {
        if (value == null) {
            return NullValue.NULL;
        }
        return new StringBuilderValue(value.toString());
    }

    public StringValue create(Env env, StringValue unicodeStr, String charset) {
        if (!unicodeStr.isUnicode()) {
            return unicodeStr;
        }
        try {
            StringValue sb = this.createStringBuilder();
            byte[] bytes = unicodeStr.toString().getBytes(charset);
            sb.append(bytes);
            return sb;
        }
        catch (UnsupportedEncodingException e) {
            env.warning(e);
            return unicodeStr;
        }
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public ValueType getValueType() {
        return ValueType.STRING;
    }

    @Override
    public boolean isLongConvertible() {
        return this.getValueType().isLongCmp();
    }

    @Override
    public boolean isDoubleConvertible() {
        return this.getValueType().isNumberCmp();
    }

    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isNumeric() {
        return this.getValueType().isNumberCmp();
    }

    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isString() {
        return true;
    }

    public boolean isPHP5String() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0 || this.length() == 1 && this.charAt(0) == '0';
    }

    @Override
    public int cmp(Value rValue) {
        if (this.isNumberConvertible() || rValue.isNumberConvertible()) {
            double r;
            double l = this.toDouble();
            if (l == (r = rValue.toDouble())) {
                return 0;
            }
            if (l < r) {
                return -1;
            }
            return 1;
        }
        int result = this.toString().compareTo(rValue.toString());
        if (result == 0) {
            return 0;
        }
        if (result > 0) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean eq(Value rValue) {
        ValueType typeA = this.getValueType();
        ValueType typeB = rValue.getValueType();
        if (typeB.isNumber()) {
            double r;
            double l = this.toDouble();
            return l == (r = rValue.toDouble());
        }
        if (typeB.isBoolean()) {
            return this.toBoolean() == rValue.toBoolean();
        }
        if (typeA.isNumberCmp() && typeB.isNumberCmp()) {
            double r;
            double l = this.toDouble();
            return l == (r = rValue.toDouble());
        }
        return this.toString().equals(rValue.toString());
    }

    public int cmpString(StringValue rValue) {
        return this.toString().compareTo(rValue.toString());
    }

    @Override
    public StringValue toStringValue() {
        return this;
    }

    public static long toLong(String string) {
        return StringValue.parseLong(string);
    }

    static long parseLong(char[] buffer, int offset, int len) {
        if (len == 0) {
            return 0L;
        }
        long value = 0L;
        long sign = 1L;
        boolean isResultSet = false;
        long result = 0L;
        int end = offset + len;
        while (offset < end && Character.isWhitespace(buffer[offset])) {
            ++offset;
        }
        if (buffer[offset] == '-') {
            sign = -1L;
            ++offset;
        } else if (buffer[offset] == '+') {
            sign = 1L;
            ++offset;
        }
        while (offset < end) {
            char ch;
            if ('0' <= (ch = buffer[offset++]) && ch <= '9') {
                long newValue = 10L * value + (long)ch - 48L;
                if (newValue < value) {
                    result = 0L;
                    isResultSet = true;
                    break;
                }
                value = newValue;
                continue;
            }
            result = sign * value;
            isResultSet = true;
            break;
        }
        if (!isResultSet) {
            result = sign * value;
        }
        return result;
    }

    static long parseLong(byte[] buffer, int offset, int len) {
        if (len == 0) {
            return 0L;
        }
        long value = 0L;
        long sign = 1L;
        boolean isResultSet = false;
        long result = 0L;
        int end = offset + len;
        if (buffer[offset] == 45) {
            sign = -1L;
            ++offset;
        } else if (buffer[offset] == 43) {
            sign = 1L;
            ++offset;
        }
        while (offset < end) {
            byte ch;
            if (48 <= (ch = buffer[offset++]) && ch <= 57) {
                long newValue = 10L * value + (long)ch - 48L;
                if (newValue < value) {
                    result = 0L;
                    isResultSet = true;
                    break;
                }
                value = newValue;
                continue;
            }
            result = sign * value;
            isResultSet = true;
            break;
        }
        if (!isResultSet) {
            result = sign * value;
        }
        return result;
    }

    static long parseLong(CharSequence string) {
        int len = string.length();
        if (len == 0) {
            return 0L;
        }
        long value = 0L;
        long sign = 1L;
        boolean isResultSet = false;
        long result = 0L;
        int offset = 0;
        boolean i = false;
        int end = offset + len;
        if (string.charAt(offset) == '-') {
            sign = -1L;
            ++offset;
        } else if (string.charAt(offset) == '+') {
            sign = 1L;
            ++offset;
        }
        while (offset < end) {
            char ch;
            if ('0' <= (ch = string.charAt(offset++)) && ch <= '9') {
                long newValue = 10L * value + (long)ch - 48L;
                if (newValue < value) {
                    result = 0L;
                    isResultSet = true;
                    break;
                }
                value = newValue;
                continue;
            }
            result = sign * value;
            isResultSet = true;
            break;
        }
        if (!isResultSet) {
            result = sign * value;
        }
        return result;
    }

    @Override
    public double toDouble() {
        return StringValue.toDouble(this.toString());
    }

    public static double toDouble(String s) {
        int i;
        int len = s.length();
        int start = 0;
        char ch = '\u0000';
        for (i = 0; i < len && Character.isWhitespace(s.charAt(i)); ++i) {
            ++start;
        }
        if (i < len && ((ch = s.charAt(i)) == '+' || ch == '-')) {
            ++i;
        }
        while (i < len && '0' <= (ch = s.charAt(i)) && ch <= '9') {
            ++i;
        }
        if (ch == '.') {
            ++i;
            while (i < len && '0' <= (ch = s.charAt(i)) && ch <= '9') {
                ++i;
            }
        }
        if (ch == 'e' || ch == 'E') {
            int e = i++;
            if (i < len && (ch = s.charAt(i)) == '+' || ch == '-') {
                ++i;
            }
            while (i < len && '0' <= (ch = s.charAt(i)) && ch <= '9') {
                ++i;
            }
            if (i == e + 1) {
                i = e;
            }
        }
        if (i == 0) {
            return 0.0;
        }
        if (i == len && start == 0) {
            return Double.parseDouble(s);
        }
        return Double.parseDouble(s.substring(start, i));
    }

    @Override
    public boolean toBoolean() {
        int length = this.length();
        if (length == 0) {
            return false;
        }
        if (length > 1) {
            return true;
        }
        return this.charAt(0) != '0';
    }

    @Override
    public Value toKey() {
        int len = this.length();
        if (len == 0) {
            return this;
        }
        int sign = 1;
        long value = 0L;
        int i = 0;
        char ch = this.charAt(i);
        if (ch == '-') {
            sign = -1;
            ++i;
        }
        while (i < len) {
            ch = this.charAt(i);
            if ('0' > ch || ch > '9') {
                return this;
            }
            value = 10L * value + (long)ch - 48L;
            ++i;
        }
        return LongValue.create((long)sign * value);
    }

    @Override
    public final Value toAutoObject(Env env) {
        return env.createObject();
    }

    @Override
    public Object toJavaObject() {
        return this.toString();
    }

    @Override
    public Object valuesToArray(Env env, Class elementType) {
        if (Character.TYPE.equals(elementType)) {
            return this.toUnicodeValue(env).toCharArray();
        }
        if (Character.class.equals((Object)elementType)) {
            char[] chars = this.toUnicodeValue(env).toCharArray();
            int length = chars.length;
            Character[] charObjects = new Character[length];
            for (int i = 0; i < length; ++i) {
                charObjects[i] = Character.valueOf(chars[i]);
            }
            return charObjects;
        }
        if (Byte.TYPE.equals(elementType)) {
            return this.toBinaryValue(env).toBytes();
        }
        if (Byte.class.equals((Object)elementType)) {
            byte[] bytes = this.toBinaryValue(env).toBytes();
            int length = bytes.length;
            Byte[] byteObjects = new Byte[length];
            for (int i = 0; i < length; ++i) {
                byteObjects[i] = bytes[i];
            }
            return byteObjects;
        }
        env.error(L.l("Can't assign {0} with type {1} to {2}", (Object)this, this.getClass(), (Object)elementType));
        return null;
    }

    @Override
    public Value toAutoArray() {
        if (this.length() == 0) {
            return new ArrayValueImpl();
        }
        return this;
    }

    @Override
    public Value get(Value key) {
        return this.charValueAt(key.toLong());
    }

    @Override
    public Value getArg(Value key) {
        return this.charValueAt(key.toLong());
    }

    @Override
    public Value getRef(Value key) {
        return this.charValueAt(key.toLong());
    }

    @Override
    public Value charValueAt(long index) {
        int len = this.length();
        if (index < 0L || (long)len <= index) {
            return UnsetUnicodeValue.UNSET;
        }
        return StringValue.create(this.charAt((int)index));
    }

    @Override
    public Value setCharValueAt(long index, String value) {
        int len = this.length();
        if (index < 0L || (long)len <= index) {
            return this;
        }
        return this.createStringBuilder().append(this, 0, (int)index).append(value).append(this, (int)(index + 1L), this.length());
    }

    @Override
    public Value preincr(int incr) {
        return this.postincr(incr);
    }

    @Override
    public Value postincr(int incr) {
        if (this.length() == 0) {
            if (incr == 1) {
                return this.createStringBuilder().append("1");
            }
            return LongValue.MINUS_ONE;
        }
        if (incr > 0) {
            StringBuilder tail = new StringBuilder();
            for (int i = this.length() - 1; i >= 0; --i) {
                char ch = this.charAt(i);
                if (ch == 'z') {
                    if (i == 0) {
                        return this.createStringBuilder().append("aa").append(tail);
                    }
                    tail.insert(0, 'a');
                    continue;
                }
                if ('a' <= ch && ch < 'z') {
                    return this.createStringBuilder().append(this, 0, i).append((char)(ch + '\u0001')).append(tail);
                }
                if (ch == 'Z') {
                    if (i == 0) {
                        return this.createStringBuilder().append("AA").append(tail);
                    }
                    tail.insert(0, 'A');
                    continue;
                }
                if ('A' <= ch && ch < 'Z') {
                    return this.createStringBuilder().append(this, 0, i).append((char)(ch + '\u0001')).append(tail);
                }
                if ('0' > ch || ch > '9' || i != this.length() - 1) continue;
                return LongValue.create(this.toLong() + (long)incr);
            }
            return this.createStringBuilder().append(tail.toString());
        }
        if (this.getValueType().isLongAdd()) {
            return LongValue.create(this.toLong() + (long)incr);
        }
        return this;
    }

    @Override
    public Value add(long rValue) {
        if (this.getValueType().isLongAdd()) {
            return LongValue.create(this.toLong() + rValue);
        }
        return DoubleValue.create(this.toDouble() + (double)rValue);
    }

    @Override
    public Value sub(long rValue) {
        if (this.getValueType().isLongAdd()) {
            return LongValue.create(this.toLong() - rValue);
        }
        return DoubleValue.create(this.toDouble() - (double)rValue);
    }

    @Override
    public Value bitAnd(Value rValue) {
        if (rValue.isString()) {
            StringValue rStr = (StringValue)rValue;
            int len = Math.min(this.length(), rValue.length());
            StringValue sb = this.createStringBuilder();
            for (int i = 0; i < len; ++i) {
                char l = this.charAt(i);
                char r = rStr.charAt(i);
                sb.appendByte(l & r);
            }
            return sb;
        }
        return LongValue.create(this.toLong() & rValue.toLong());
    }

    @Override
    public Value bitOr(Value rValue) {
        if (rValue.isString()) {
            StringValue rStr = (StringValue)rValue;
            int len = Math.min(this.length(), rValue.length());
            StringValue sb = this.createStringBuilder();
            for (int i = 0; i < len; ++i) {
                char l = this.charAt(i);
                char r = rStr.charAt(i);
                sb.appendByte(l | r);
            }
            if (len != this.length()) {
                sb.append(this.substring(len));
            } else if (len != rStr.length()) {
                sb.append(rStr.substring(len));
            }
            return sb;
        }
        return LongValue.create(this.toLong() | rValue.toLong());
    }

    @Override
    public Value bitXor(Value rValue) {
        if (rValue.isString()) {
            StringValue rStr = (StringValue)rValue;
            int len = Math.min(this.length(), rValue.length());
            StringValue sb = this.createStringBuilder();
            for (int i = 0; i < len; ++i) {
                char l = this.charAt(i);
                char r = rStr.charAt(i);
                sb.appendByte(l ^ r);
            }
            return sb;
        }
        return LongValue.create(this.toLong() ^ rValue.toLong());
    }

    @Override
    public void serialize(Env env, StringBuilder sb) {
        sb.append("s:");
        sb.append(this.length());
        sb.append(":\"");
        sb.append(this.toString());
        sb.append("\";");
    }

    public StringValue append(String s) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(String s, int start, int end) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(char[] buf, int offset, int length) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(char[] buf) {
        return this.append(buf, 0, buf.length);
    }

    public StringValue append(CharSequence buf, int head, int tail) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(UnicodeBuilderValue sb, int head, int tail) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(Env env, StringValue unicodeStr, String charset) {
        if (!unicodeStr.isUnicode()) {
            return this.append(unicodeStr);
        }
        try {
            byte[] bytes = unicodeStr.toString().getBytes(charset);
            this.append(bytes);
            return this;
        }
        catch (UnsupportedEncodingException e) {
            env.warning(e);
            return this.append(unicodeStr);
        }
    }

    public StringValue append(char v) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(boolean v) {
        return this.append(v ? "true" : "false");
    }

    public StringValue append(long v) {
        return this.append(String.valueOf(v));
    }

    public StringValue append(double v) {
        return this.append(String.valueOf(v));
    }

    public StringValue append(Object v) {
        return this.append(String.valueOf(v));
    }

    public StringValue append(Value v) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void ensureAppendCapacity(int size) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(byte[] buf, int offset, int length) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(byte[] buf) {
        return this.append(buf, 0, buf.length);
    }

    @Override
    public StringValue appendTo(UnicodeBuilderValue sb) {
        int length = this.length();
        for (int i = 0; i < length; ++i) {
            sb.append(this.charAt(i));
        }
        return this;
    }

    public StringValue appendUnicode(boolean v) {
        return this.append(v ? "true" : "false");
    }

    public StringValue appendUnicode(long v) {
        return this.append(String.valueOf(v));
    }

    public StringValue appendUnicode(double v) {
        return this.append(String.valueOf(v));
    }

    public StringValue appendUnicode(Object v) {
        return this.append(String.valueOf(v));
    }

    public StringValue appendUnicode(char v) {
        return this.append(v);
    }

    public StringValue appendUnicode(char[] buffer, int offset, int length) {
        return this.append(buffer, offset, length);
    }

    public StringValue appendUnicode(char[] buffer) {
        return this.append(buffer);
    }

    public StringValue appendUnicode(String value) {
        return this.append(value);
    }

    public StringValue appendUnicode(String value, int offset, int length) {
        return this.append(value, offset, length);
    }

    public StringValue appendUnicode(Value value) {
        return this.append(value);
    }

    public StringValue appendUnicode(Value v1, Value v2) {
        return this.append(v1).append(v2);
    }

    public StringValue appendByte(int v) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue appendBytes(String s) {
        StringValue sb = this;
        for (int i = 0; i < s.length(); ++i) {
            sb = sb.appendByte(s.charAt(i));
        }
        return sb;
    }

    public StringValue appendBytes(char[] buf, int offset, int length) {
        StringValue sb = this;
        int end = Math.min(buf.length, offset + length);
        while (offset < end) {
            sb = sb.appendByte(buf[offset++]);
        }
        return sb;
    }

    public StringValue appendBytes(byte[] bytes, int offset, int end) {
        StringValue sb = this;
        while (offset < end) {
            sb = sb.appendByte(bytes[offset++]);
        }
        return sb;
    }

    public StringValue append(Reader reader) throws IOException {
        int ch;
        while ((ch = reader.read()) >= 0) {
            this.append((char)ch);
        }
        return this;
    }

    public StringValue append(Reader reader, long length) throws IOException {
        int ch;
        while (length-- > 0L && (ch = reader.read()) >= 0) {
            this.append((char)ch);
        }
        return this;
    }

    public int appendRead(InputStream is, long length) {
        TempBuffer tBuf = TempBuffer.allocate();
        try {
            byte[] buffer = tBuf.getBuffer();
            int sublen = buffer.length;
            if (length < (long)sublen) {
                sublen = (int)length;
            }
            if ((sublen = is.read(buffer, 0, sublen)) > 0) {
                this.append(buffer, 0, sublen);
            }
            int n = sublen;
            return n;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        finally {
            TempBuffer.free((TempBuffer)tBuf);
        }
    }

    public int appendReadAll(InputStream is, long length) {
        TempBuffer tBuf = TempBuffer.allocate();
        try {
            byte[] buffer = tBuf.getBuffer();
            int readLength = 0;
            while (length > 0L) {
                int sublen = buffer.length;
                if (length < (long)sublen) {
                    sublen = (int)length;
                }
                if ((sublen = is.read(buffer, 0, sublen)) > 0) {
                    this.append(buffer, 0, sublen);
                    length -= (long)sublen;
                    readLength += sublen;
                    continue;
                }
                int n = readLength > 0 ? readLength : -1;
                return n;
            }
            int n = readLength;
            return n;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        finally {
            TempBuffer.free((TempBuffer)tBuf);
        }
    }

    public int appendRead(BinaryInput is, long length) {
        TempBuffer tBuf = TempBuffer.allocate();
        try {
            byte[] buffer = tBuf.getBuffer();
            int sublen = buffer.length;
            if (length < (long)sublen) {
                sublen = (int)length;
            } else if (length > (long)sublen) {
                buffer = new byte[(int)length];
                sublen = (int)length;
            }
            sublen = is.read(buffer, 0, sublen);
            if (sublen > 0) {
                this.append(buffer, 0, sublen);
            }
            int n = sublen;
            return n;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        finally {
            TempBuffer.free((TempBuffer)tBuf);
        }
    }

    public int appendReadAll(BinaryInput is, long length) {
        TempBuffer tBuf = TempBuffer.allocate();
        try {
            byte[] buffer = tBuf.getBuffer();
            int readLength = 0;
            while (length > 0L) {
                int sublen = buffer.length;
                if (length < (long)sublen) {
                    sublen = (int)length;
                }
                if ((sublen = is.read(buffer, 0, sublen)) > 0) {
                    this.append(buffer, 0, sublen);
                    length -= (long)sublen;
                    readLength += sublen;
                    continue;
                }
                int n = readLength > 0 ? readLength : -1;
                return n;
            }
            int n = readLength;
            return n;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        finally {
            TempBuffer.free((TempBuffer)tBuf);
        }
    }

    @Override
    public void varExport(StringBuilder sb) {
        sb.append("'");
        String value = this.toString();
        int len = value.length();
        block4: for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\'': {
                    sb.append("\\'");
                    continue block4;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block4;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        sb.append("'");
    }

    public StringValue intern(Quercus quercus) {
        return quercus.intern(this.toString());
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new StringBuilderValue(this.toString().substring(start, end));
    }

    public final int indexOf(CharSequence match) {
        return this.indexOf(match, 0);
    }

    public int indexOf(CharSequence match, int head) {
        int length = this.length();
        int matchLength = match.length();
        if (matchLength <= 0) {
            return -1;
        }
        if (head < 0) {
            return -1;
        }
        int end = length - matchLength;
        char first = match.charAt(0);
        while (head <= end) {
            block6: {
                if (this.charAt(head) == first) {
                    for (int i = 1; i < matchLength; ++i) {
                        if (this.charAt(head + i) == match.charAt(i)) {
                            continue;
                        }
                        break block6;
                    }
                    return head;
                }
            }
            ++head;
        }
        return -1;
    }

    public int indexOf(char match) {
        return this.indexOf(match, 0);
    }

    public int indexOf(char match, int head) {
        int length = this.length();
        while (head < length) {
            if (this.charAt(head) == match) {
                return head;
            }
            ++head;
        }
        return -1;
    }

    public final int lastIndexOf(char match) {
        return this.lastIndexOf(match, Integer.MAX_VALUE);
    }

    public int lastIndexOf(char match, int tail) {
        int length = this.length();
        if (tail >= length) {
            tail = length - 1;
        }
        while (tail >= 0) {
            if (this.charAt(tail) == match) {
                return tail;
            }
            --tail;
        }
        return -1;
    }

    public int lastIndexOf(CharSequence match) {
        return this.lastIndexOf(match, Integer.MAX_VALUE);
    }

    public int lastIndexOf(CharSequence match, int tail) {
        int length = this.length();
        int matchLength = match.length();
        if (matchLength <= 0) {
            return -1;
        }
        if (tail < 0) {
            return -1;
        }
        if (tail > length - matchLength) {
            tail = length - matchLength;
        }
        char first = match.charAt(0);
        while (tail >= 0) {
            block7: {
                if (this.charAt(tail) == first) {
                    for (int i = 1; i < matchLength; ++i) {
                        if (this.charAt(tail + i) == match.charAt(i)) {
                            continue;
                        }
                        break block7;
                    }
                    return tail;
                }
            }
            --tail;
        }
        return -1;
    }

    public boolean regionMatches(int offset, char[] mBuffer, int mOffset, int mLength) {
        int length = this.length();
        if (length < offset + mLength) {
            return false;
        }
        for (int i = 0; i < mLength; ++i) {
            if (this.charAt(offset + i) == mBuffer[mOffset + i]) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatches(int offset, StringValue match, int mOffset, int mLength) {
        int length = this.length();
        if (length < offset + mLength) {
            return false;
        }
        for (int i = 0; i < mLength; ++i) {
            if (this.charAt(offset + i) == match.charAt(mOffset + i)) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatchesIgnoreCase(int offset, char[] match, int mOffset, int mLength) {
        int length = this.length();
        if (length < offset + mLength) {
            return false;
        }
        for (int i = 0; i < mLength; ++i) {
            char b;
            char a = Character.toLowerCase(this.charAt(offset + i));
            if (a == (b = Character.toLowerCase(match[mOffset + i]))) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(StringValue tail) {
        int tailLen;
        int len = this.length();
        int offset = len - (tailLen = tail.length());
        if (offset < 0) {
            return false;
        }
        for (int i = 0; i < tailLen; ++i) {
            if (this.charAt(offset + i) == tail.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public StringValue substring(int head) {
        return (StringValue)this.subSequence(head, this.length());
    }

    public StringValue substring(int begin, int end) {
        return (StringValue)this.subSequence(begin, end);
    }

    public char[] toCharArray() {
        int length = this.length();
        char[] array = new char[this.length()];
        this.getChars(0, array, 0, length);
        return array;
    }

    public char[] getRawCharArray() {
        return this.toCharArray();
    }

    public void getChars(int stringOffset, char[] buffer, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            buffer[offset + i] = this.charAt(stringOffset + i);
        }
    }

    public StringValue toLowerCase() {
        int length = this.length();
        UnicodeBuilderValue string = new UnicodeBuilderValue(length);
        char[] buffer = string.getBuffer();
        this.getChars(0, buffer, 0, length);
        for (int i = 0; i < length; ++i) {
            char ch = buffer[i];
            if ('A' <= ch && ch <= 'Z') {
                buffer[i] = (char)(ch + 97 - 65);
                continue;
            }
            if (ch < '\u0080' || !Character.isUpperCase(ch)) continue;
            buffer[i] = Character.toLowerCase(ch);
        }
        string.setOffset(length);
        return string;
    }

    public StringValue toUpperCase() {
        int length = this.length();
        UnicodeBuilderValue string = new UnicodeBuilderValue(length);
        char[] buffer = string.getBuffer();
        this.getChars(0, buffer, 0, length);
        for (int i = 0; i < length; ++i) {
            char ch = buffer[i];
            if ('a' <= ch && ch <= 'z') {
                buffer[i] = (char)(ch + 65 - 97);
                continue;
            }
            if (ch < '\u0080' || !Character.isLowerCase(ch)) continue;
            buffer[i] = Character.toUpperCase(ch);
        }
        string.setOffset(length);
        return string;
    }

    @Override
    public InputStream toInputStream() {
        try {
            return this.toInputStream(Env.getInstance().getRuntimeEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    public InputStream toInputStream(String charset) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(this.toString().getBytes(charset));
    }

    public Reader toReader(String charset) throws UnsupportedEncodingException {
        byte[] bytes = this.toBytes();
        return new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), charset);
    }

    public StringValue toBinaryValue(Env env, String charset) {
        TempBuffer tb = TempBuffer.allocate();
        byte[] buffer = tb.getBuffer();
        try {
            InputStream in = this.toInputStream(charset);
            TempStream out = new TempStream();
            int sublen = in.read(buffer, 0, buffer.length);
            while (sublen >= 0) {
                out.write(buffer, 0, sublen, false);
                sublen = in.read(buffer, 0, buffer.length);
            }
            out.flush();
            StringValue result = env.createBinaryBuilder();
            for (TempBuffer ptr = out.getHead(); ptr != null; ptr = ptr.getNext()) {
                result.append(ptr.getBuffer(), 0, ptr.getLength());
            }
            TempBuffer.free((TempBuffer)out.getHead());
            StringValue stringValue = result;
            return stringValue;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e.getMessage());
        }
        finally {
            TempBuffer.free((TempBuffer)tb);
        }
    }

    public byte[] toBytes() {
        throw new UnsupportedOperationException();
    }

    public StringValue toUnicodeValue(Env env, String charset) {
        StringValue sb = env.createUnicodeBuilder();
        Decoder decoder = Decoder.create(charset);
        sb.append(decoder.decode(env, this));
        return sb;
    }

    public StringValue convertToUnicode(Env env, String charset) {
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        Decoder decoder = Decoder.create(charset);
        decoder.setAllowMalformedOut(true);
        sb.append(decoder.decode(env, this));
        return sb;
    }

    @Override
    public StringValue toStringBuilder(Env env) {
        return this.createStringBuilder().append(this);
    }

    public void writeTo(OutputStream os) {
        try {
            int len = this.length();
            for (int i = 0; i < len; ++i) {
                os.write(this.charAt(i));
            }
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public int hashCode() {
        int hash = 37;
        int length = this.length();
        for (int i = 0; i < length; ++i) {
            hash = 65521 * hash + this.charAt(i);
        }
        return hash;
    }

    public boolean equals(Object o) {
        int bLength;
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringValue)) {
            return false;
        }
        StringValue s = (StringValue)o;
        if (s.isUnicode() != this.isUnicode()) {
            return false;
        }
        int aLength = this.length();
        if (aLength != (bLength = s.length())) {
            return false;
        }
        for (int i = aLength - 1; i >= 0; --i) {
            if (this.charAt(i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void generate(PrintWriter out) throws IOException {
        int maxSublen = 65534;
        int len = this.length();
        String className = this.getClass().getSimpleName();
        if (len < maxSublen) {
            out.print("new " + className + "(\"");
            StringValue.printJavaString(out, this);
            out.print("\")");
        } else {
            out.print("((" + className + ") (new " + className + "(\"");
            for (int i = 0; i < len; i += maxSublen) {
                if (i != 0) {
                    out.print("\").append(\"");
                }
                StringValue.printJavaString(out, this.substring(i, Math.min(i + maxSublen, len)));
            }
            out.print("\")))");
        }
    }

    @Override
    public abstract String toDebugString();

    @Override
    public abstract void varDumpImpl(Env var1, WriteStream var2, int var3, IdentityHashMap<Value, String> var4) throws IOException;

    static {
        for (int i = 0; i < CHAR_STRINGS.length; ++i) {
            StringValue.CHAR_STRINGS[i] = new StringBuilderValue(String.valueOf((char)i));
        }
    }

    class StringValueInputStream
    extends InputStream {
        private final int _length;
        private int _index;

        StringValueInputStream() {
            this._length = StringValue.this.length();
        }

        public int read() {
            if (this._index < this._length) {
                return StringValue.this.charAt(this._index++);
            }
            return -1;
        }

        public int read(byte[] buffer, int offset, int length) {
            int sublen = this._length - this._index;
            if (length < sublen) {
                sublen = length;
            }
            if (sublen <= 0) {
                return -1;
            }
            int index = this._index;
            for (int i = 0; i < sublen; ++i) {
                buffer[offset + i] = (byte)StringValue.this.charAt(index + i);
            }
            this._index += sublen;
            return sublen;
        }
    }
}

