/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.util.L10N;

public class StaticFieldGetExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(StaticFieldGetExpr.class);
    protected final String _className;
    protected final String _varName;

    public StaticFieldGetExpr(Location location, String className, String varName) {
        super(location);
        this._className = className;
        this._varName = varName;
    }

    public StaticFieldGetExpr(String className, String varName) {
        this._className = className;
        this._varName = varName;
    }

    public Value eval(Env env) {
        return env.getStaticClassFieldValue(this._className, this._varName);
    }

    public Value evalCopy(Env env) {
        return env.getStaticClassFieldVar(this._className, this._varName).copy();
    }

    public Value evalArg(Env env) {
        return env.getStaticClassFieldVar(this._className, this._varName);
    }

    public Value evalArray(Env env) {
        return env.getStaticClassFieldVar(this._className, this._varName).getArray();
    }

    public Value evalObject(Env env) {
        return env.getStaticClassFieldVar(this._className, this._varName).getObject(env);
    }

    public Value evalRef(Env env) {
        return env.getStaticClassFieldVar(this._className, this._varName);
    }

    public void evalAssign(Env env, Value value) {
        env.getStaticClassFieldVar(this._className, this._varName).set(value);
    }

    public void evalUnset(Env env) {
        env.error(this.getLocation(), L.l("{0}::${1}: Cannot unset static variables.", (Object)this._className, (Object)this._varName));
    }

    public String toString() {
        return this._className + "::$" + this._varName;
    }
}

