/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.zlib;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.lib.file.AbstractBinaryOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class ZlibOutputStream
extends AbstractBinaryOutput {
    private OutputStream _os;
    private DeflaterOutputStream _out;
    private CRC32 _crc32;
    private byte[] _header = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 3};
    private int _encodingMode;
    private boolean _isGzip;
    private long _inputSize;

    private ZlibOutputStream(OutputStream os, Deflater def) throws IOException {
        this._os = os;
        this._out = new DeflaterOutputStream(this._os, def);
        this._os.write(this._header, 0, this._header.length);
    }

    public ZlibOutputStream(OutputStream os, int compressionLevel, int strategy, int encodingMode) throws IOException {
        this(os, ZlibOutputStream.createDeflater(compressionLevel, strategy, encodingMode));
        boolean bl = this._isGzip = encodingMode == 1;
        if (this._isGzip) {
            this._crc32 = new CRC32();
        }
    }

    public ZlibOutputStream(OutputStream os, int compressionLevel, int strategy) throws IOException {
        this(os, compressionLevel, strategy, 1);
    }

    public ZlibOutputStream(OutputStream os) throws IOException {
        this(os, -1, 0, 1);
    }

    private static Deflater createDeflater(int compressionLevel, int strategy, int encodingMode) {
        Deflater def = encodingMode == 1 ? new Deflater(compressionLevel, true) : new Deflater(compressionLevel, false);
        def.setStrategy(strategy);
        return def;
    }

    public void write(int v) throws IOException {
        this._out.write(v);
        ++this._inputSize;
        if (this._isGzip) {
            this._crc32.update(v);
        }
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        this._out.write(buffer, offset, length);
        this._inputSize += (long)length;
        if (this._isGzip) {
            this._crc32.update(buffer, offset, length);
        }
    }

    private void finish(DeflaterOutputStream out) throws IOException {
        out.finish();
        OutputStream os = this._os;
        if (this._isGzip) {
            long crcValue = this._crc32.getValue();
            byte[] trailerCRC = new byte[]{(byte)crcValue, (byte)(crcValue >> 8), (byte)(crcValue >> 16), (byte)(crcValue >> 24)};
            this._os.write(trailerCRC, 0, trailerCRC.length);
        }
        this._os.write((byte)this._inputSize);
        this._os.write((byte)(this._inputSize >> 8));
        this._os.write((byte)(this._inputSize >> 16));
        this._os.write((byte)(this._inputSize >> 24));
        this._os.flush();
    }

    public void flush() {
    }

    public void closeWrite() {
        this.close();
    }

    public void close() {
        try {
            DeflaterOutputStream out = this._out;
            this._out = null;
            if (out != null) {
                this.finish(out);
                out.close();
            }
            this._os.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEOF() {
        return false;
    }

    public long getPosition() {
        return this._inputSize;
    }

    public boolean setPosition(long offset) {
        if (offset < this._inputSize) {
            return false;
        }
        offset -= this._inputSize;
        byte[] buffer = new byte[128];
        try {
            while (offset > 0L) {
                int sublen = (int)Math.min(offset, (long)buffer.length);
                this.write(buffer, 0, sublen);
                offset -= (long)sublen;
            }
            return true;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public String toString() {
        return "ZlibOutputStream[]";
    }
}

