/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.internal;

import java.io.IOException;
import org.asteriskjava.fastagi.AgiException;
import org.asteriskjava.fastagi.AgiWriter;
import org.asteriskjava.fastagi.command.AgiCommand;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.manager.action.AgiAction;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;

public class AsyncAgiWriter
implements AgiWriter {
    private final ManagerConnection connection;
    private volatile String channelName;

    public AsyncAgiWriter(ManagerConnection connection, String channelName) {
        this.connection = connection;
        this.channelName = channelName;
    }

    @Override
    public void sendCommand(AgiCommand command) throws AgiException {
        ManagerResponse response;
        AgiAction agiAction = new AgiAction(this.channelName, command.buildCommand());
        try {
            response = this.connection.sendAction(agiAction);
        }
        catch (IOException e) {
            throw new AgiException("Unable to send AsyncAGI command to " + this.connection.getHostname() + " for channel " + this.channelName, e);
        }
        catch (TimeoutException e) {
            throw new AgiException("Timeout while sending AsyncAGI command to " + this.connection.getHostname() + " for channel " + this.channelName, e);
        }
        if (response instanceof ManagerError) {
            throw new AgiException("Unable to send AsyncAGI command to " + this.connection.getHostname() + " for channel " + this.channelName + ": " + response.getMessage());
        }
    }

    public void updateChannelName(String channelName) {
        this.channelName = channelName;
    }
}

