/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.agi;

import java.util.LinkedList;
import java.util.List;

public class RateLimiter {
    private static final long ONE_THOUSAND_MILLIS = 1000L;
    List<Long> available = new LinkedList<Long>();

    RateLimiter(int perSecond) {
        long now = System.currentTimeMillis();
        for (int i = 0; i < perSecond; ++i) {
            this.available.add(now - 1000L);
        }
    }

    void acquire() throws InterruptedException {
        long now = System.currentTimeMillis();
        Long next = this.available.remove(0);
        long timeRemaining = next - now;
        if (timeRemaining > 0L) {
            Thread.sleep(timeRemaining);
        }
        this.available.add(System.currentTimeMillis() + 1000L);
    }
}

