/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.location.template;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.Strand;
import org.biojava.nbio.core.sequence.location.template.Location;
import org.biojava.nbio.core.sequence.location.template.Point;
import org.biojava.nbio.core.sequence.storage.JoiningSequenceReader;
import org.biojava.nbio.core.sequence.template.ComplementCompound;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.core.sequence.views.ComplementSequenceView;
import org.biojava.nbio.core.sequence.views.ReversedSequenceView;
import org.biojava.nbio.core.util.Equals;
import org.biojava.nbio.core.util.Hashcoder;

public abstract class AbstractLocation
implements Serializable,
Location {
    private static final long serialVersionUID = 1L;
    private Point start;
    private Point end;
    private Strand strand;
    private List<Location> subLocations;
    private boolean circular;
    private boolean betweenCompounds;
    private AccessionID accession;
    private boolean partialOn5prime = false;
    private boolean partialOn3prime = false;

    protected AbstractLocation() {
    }

    public AbstractLocation(Point start, Point end, Strand strand, boolean circular, boolean betweenCompounds, List<Location> subLocations) {
        this(start, end, strand, circular, betweenCompounds, null, subLocations);
    }

    public AbstractLocation(Point start, Point end, Strand strand, boolean circular, boolean betweenCompounds, AccessionID accession, List<Location> subLocations) {
        this.start = start;
        this.end = end;
        this.strand = strand;
        this.circular = circular;
        this.betweenCompounds = betweenCompounds;
        this.accession = accession;
        this.subLocations = subLocations == null ? null : Collections.unmodifiableList(subLocations);
        this.assertLocation();
    }

    protected void assertLocation() {
        int e;
        if (this.isCircular() && !this.isComplex()) {
            throw new IllegalStateException("Cannot have a circular location which is not complex");
        }
        int st = this.getStart().getPosition();
        if (st > (e = this.getEnd().getPosition().intValue())) {
            throw new IllegalStateException(String.format("Start (%d) is greater than end (%d); this is an incorrect format", st, e));
        }
        if (this.isBetweenCompounds() && this.isComplex()) {
            throw new IllegalStateException("Cannot have a complex location which is located between a pair of compounds");
        }
        if (this.isBetweenCompounds() && st + 1 != e) {
            throw new IllegalStateException(String.format("Start (%d) is not next to end (%d)", st, e));
        }
    }

    @Override
    public Point getEnd() {
        return this.end;
    }

    @Override
    public Point getStart() {
        return this.start;
    }

    @Override
    public int getLength() {
        return this.getEnd().getPosition() - this.getStart().getPosition() + 1;
    }

    @Override
    public Strand getStrand() {
        return this.strand;
    }

    @Override
    public List<Location> getSubLocations() {
        if (this.subLocations == null) {
            return Collections.emptyList();
        }
        return this.subLocations;
    }

    @Override
    public boolean isComplex() {
        return !this.getSubLocations().isEmpty();
    }

    @Override
    public AccessionID getAccession() {
        return this.accession;
    }

    public boolean isPartialOn5prime() {
        return this.partialOn5prime;
    }

    public void setPartialOn5prime(boolean partialOn5prime) {
        this.partialOn5prime = partialOn5prime;
    }

    public boolean isPartialOn3prime() {
        return this.partialOn3prime;
    }

    public void setPartialOn3prime(boolean partialOn3prime) {
        this.partialOn3prime = partialOn3prime;
    }

    public boolean isPartial() {
        return this.partialOn5prime || this.partialOn3prime;
    }

    @Override
    public Iterator<Location> iterator() {
        List<Location> list;
        if (this.isComplex()) {
            list = this.getSubLocations();
        } else {
            list = new ArrayList<Location>();
            list.add(this);
        }
        return list.iterator();
    }

    @Override
    public List<Location> getRelevantSubLocations() {
        return this.getAllSubLocations(this);
    }

    private List<Location> getAllSubLocations(Location location) {
        ArrayList<Location> flatSubLocations = new ArrayList<Location>();
        for (Location l : location.getSubLocations()) {
            if (l.isComplex()) {
                flatSubLocations.addAll(this.getAllSubLocations(l));
                continue;
            }
            flatSubLocations.add(l);
        }
        return flatSubLocations;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (Equals.classEqual(this, obj)) {
            AbstractLocation l = (AbstractLocation)obj;
            equals = Equals.equal(this.getStart(), l.getStart()) && Equals.equal(this.getEnd(), l.getEnd()) && Equals.equal((Object)this.getStrand(), (Object)l.getStrand()) && Equals.equal(this.isCircular(), l.isCircular()) && Equals.equal(this.isBetweenCompounds(), l.isBetweenCompounds()) && Equals.equal(this.getSubLocations(), l.getSubLocations()) && Equals.equal(this.getAccession(), l.getAccession());
        }
        return equals;
    }

    public int hashCode() {
        int r = 9;
        r = Hashcoder.hash(r, this.getStart());
        r = Hashcoder.hash(r, this.getEnd());
        r = Hashcoder.hash(r, (Object)this.getStrand());
        r = Hashcoder.hash(r, this.isCircular());
        r = Hashcoder.hash(r, this.isBetweenCompounds());
        r = Hashcoder.hash(r, this.getSubLocations());
        r = Hashcoder.hash(r, this.getAccession());
        return r;
    }

    @Override
    public boolean isCircular() {
        return this.circular;
    }

    @Override
    public boolean isBetweenCompounds() {
        return this.betweenCompounds;
    }

    @Override
    public <C extends Compound> Sequence<C> getSubSequence(Sequence<C> sequence) {
        if (this.isCircular()) {
            ArrayList sequences = new ArrayList();
            for (Location l : this) {
                sequences.add(l.getSubSequence(sequence));
            }
            return new JoiningSequenceReader<C>(sequence.getCompoundSet(), sequences);
        }
        return this.reverseSequence(sequence.getSubSequence(this.getStart().getPosition(), this.getEnd().getPosition()));
    }

    @Override
    public <C extends Compound> Sequence<C> getRelevantSubSequence(Sequence<C> sequence) {
        ArrayList sequences = new ArrayList();
        for (Location l : this.getRelevantSubLocations()) {
            sequences.add(l.getSubSequence(sequence));
        }
        return new JoiningSequenceReader<C>(sequence.getCompoundSet(), sequences);
    }

    protected <C extends Compound> Sequence<C> reverseSequence(Sequence<C> sequence) {
        if (this.getStrand() != Strand.NEGATIVE) {
            return sequence;
        }
        ReversedSequenceView<C> reversed = new ReversedSequenceView<C>(sequence);
        if (this.canComplement(sequence)) {
            ReversedSequenceView<C> casted = reversed;
            ComplementSequenceView<C> complement = new ComplementSequenceView<C>(casted);
            return complement;
        }
        return reversed;
    }

    protected <C extends Compound> boolean canComplement(Sequence<C> sequence) {
        CompoundSet<C> compoundSet = sequence.getCompoundSet();
        Compound c = (Compound)compoundSet.getAllCompounds().iterator().next();
        return ComplementCompound.class.isAssignableFrom(c.getClass());
    }

    public String toString() {
        String circ = this.isCircular() ? " - circular" : "";
        String between = this.isBetweenCompounds() ? "^" : "..";
        return String.format("%d%s%d(%s%s)", this.getStart().getPosition(), between, this.getEnd().getPosition(), this.getStrand().getStringRepresentation(), circ);
    }

    protected void setCircular(boolean circular) {
        this.circular = circular;
    }

    protected void setEnd(Point end) {
        this.end = end;
    }

    protected void setStart(Point start) {
        this.start = start;
    }

    public void setStrand(Strand strand) {
        this.strand = strand;
    }

    public void setBetweenCompounds(boolean betweenCompounds) {
        this.betweenCompounds = betweenCompounds;
    }

    public void setSubLocations(List<Location> subLocations) {
        this.subLocations = subLocations;
    }

    public void setAccession(AccessionID accession) {
        this.accession = accession;
    }
}

