/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence;

import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.Strand;
import org.biojava.nbio.core.sequence.TranscriptSequence;
import org.biojava.nbio.core.sequence.compound.DNACompoundSet;
import org.biojava.nbio.core.sequence.compound.NucleotideCompound;
import org.biojava.nbio.core.sequence.template.CompoundSet;

public class CDSSequence
extends DNASequence {
    Integer phase = 0;
    TranscriptSequence parentTranscriptSequence;

    public CDSSequence(TranscriptSequence parentSequence, int bioBegin, int bioEnd, int phase) {
        this.parentTranscriptSequence = parentSequence;
        this.setParentSequence(this.parentTranscriptSequence);
        this.setBioBegin(bioBegin);
        this.setBioEnd(bioEnd);
        this.phase = phase;
        this.setCompoundSet(DNACompoundSet.getDNACompoundSet());
    }

    @Override
    public int getLength() {
        return Math.abs(this.getBioEnd() - this.getBioBegin()) + 1;
    }

    public Integer getPhase() {
        return this.phase;
    }

    public Strand getStrand() {
        return this.parentTranscriptSequence.getStrand();
    }

    public String getCodingSequence() {
        String sequence = this.getSequenceAsString(this.getBioBegin(), this.getBioEnd(), this.getStrand());
        if (this.getStrand() == Strand.NEGATIVE) {
            StringBuilder b = new StringBuilder(this.getLength());
            CompoundSet compoundSet = this.getCompoundSet();
            for (int i = 0; i < sequence.length(); ++i) {
                String nucleotide = String.valueOf(sequence.charAt(i));
                NucleotideCompound nucleotideCompound = (NucleotideCompound)compoundSet.getCompoundForString(nucleotide);
                b.append(nucleotideCompound.getComplement().getShortName());
            }
            sequence = b.toString();
        }
        return sequence;
    }
}

