/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.DataSource;
import org.biojava.nbio.core.sequence.compound.AmbiguityDNACompoundSet;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.compound.DNACompoundSet;
import org.biojava.nbio.core.sequence.compound.NucleotideCompound;
import org.biojava.nbio.core.sequence.features.Qualifier;
import org.biojava.nbio.core.sequence.io.DNASequenceCreator;
import org.biojava.nbio.core.sequence.io.FastaReader;
import org.biojava.nbio.core.sequence.io.PlainFastaHeaderParser;
import org.biojava.nbio.core.sequence.location.InsdcParser;
import org.biojava.nbio.core.sequence.location.template.Location;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.ProxySequenceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProteinSequence
extends AbstractSequence<AminoAcidCompound> {
    private static final Logger logger = LoggerFactory.getLogger(ProteinSequence.class);

    public ProteinSequence(String seqString) throws CompoundNotFoundException {
        this(seqString, (CompoundSet<AminoAcidCompound>)AminoAcidCompoundSet.getAminoAcidCompoundSet());
    }

    public ProteinSequence(String seqString, CompoundSet<AminoAcidCompound> compoundSet) throws CompoundNotFoundException {
        super(seqString, compoundSet);
    }

    public ProteinSequence(ProxySequenceReader<AminoAcidCompound> proxyLoader) {
        this(proxyLoader, (CompoundSet<AminoAcidCompound>)AminoAcidCompoundSet.getAminoAcidCompoundSet());
    }

    public ProteinSequence(ProxySequenceReader<AminoAcidCompound> proxyLoader, CompoundSet<AminoAcidCompound> compoundSet) {
        super(proxyLoader, compoundSet);
        Qualifier codedBy;
        List CDSFeatures = this.getFeaturesByType("CDS");
        if (CDSFeatures.size() == 1 && (codedBy = CDSFeatures.get(0).getQualifiers().get("coded_by").get(0)) != null) {
            String codedBySeq = codedBy.getValue();
            InsdcParser parser = new InsdcParser(DataSource.GENBANK);
            Location location = parser.parse(codedBySeq);
            try {
                DNASequence dnaSeq = new DNASequence(this.getSequence(location), (CompoundSet<NucleotideCompound>)DNACompoundSet.getDNACompoundSet());
                this.setParentDNASequence(dnaSeq, location.getStart().getPosition(), location.getEnd().getPosition());
            }
            catch (CompoundNotFoundException e) {
                logger.error("Could not add 'coded_by' parent DNA location feature, unrecognised compounds found in DNA sequence: {}", (Object)e.getMessage());
            }
        }
    }

    public void setParentDNASequence(AbstractSequence<NucleotideCompound> parentDNASequence, Integer begin, Integer end) {
        this.setParentSequence(parentDNASequence);
        this.setBioBegin(begin);
        this.setBioEnd(end);
    }

    private DNASequence getRawParentSequence(String accessId) throws IOException {
        String seqUrlTemplate = "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=nuccore&id=%s&rettype=fasta&retmode=text";
        URL url = new URL(String.format(seqUrlTemplate, accessId));
        logger.trace("Getting parent DNA sequence from URL: {}", (Object)url.toString());
        InputStream is = url.openConnection().getInputStream();
        FastaReader parentReader = new FastaReader(is, new PlainFastaHeaderParser(), new DNASequenceCreator(AmbiguityDNACompoundSet.getDNACompoundSet()));
        Map seq = parentReader.process();
        DNASequence parentSeq = null;
        if (seq.size() == 1) {
            parentSeq = (DNASequence)seq.values().iterator().next();
        }
        is.close();
        return parentSeq;
    }

    private String getSequence(Location cdna) {
        if (!cdna.isComplex()) {
            try {
                DNASequence rawParent = this.getRawParentSequence(cdna.getAccession().getID());
                return cdna.getSubSequence(rawParent).getSequenceAsString();
            }
            catch (IOException e) {
                logger.error("Caught IOException when getting DNA sequence for id {}. Error: {}", (Object)cdna.getAccession().getID(), (Object)e.getMessage());
                return null;
            }
        }
        StringBuilder sb = new StringBuilder();
        for (Location sub : cdna.getSubLocations()) {
            String sebStr = this.getSequence(sub);
            sb.append(sebStr == null ? "" : sebStr);
        }
        return sb.toString();
    }
}

