/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.phosphosite;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.phosphosite.Site;
import org.biojava.nbio.structure.align.util.AtomCache;

public class Dataset {
    public static final String ACETYLATION = "http://www.phosphosite.org/downloads/Acetylation_site_dataset.gz";
    public static final String DISEASE_ASSOC = "http://www.phosphosite.org/downloads/Disease-associated_sites.gz";
    public static final String METHYLATION = "http://www.phosphosite.org/downloads/Methylation_site_dataset.gz";
    public static final String PHOSPHORYLATION = "http://www.phosphosite.org/downloads/Phosphorylation_site_dataset.gz";
    public static final String REGULATORY = "http://www.phosphosite.org/downloads/Regulatory_sites.gz";
    public static final String SUMOYLATION = "http://www.phosphosite.org/downloads/Sumoylation_site_dataset.gz";
    public static final String UBIQUITINATION = "http://www.phosphosite.org/downloads/Ubiquitination_site_dataset.gz";

    private String[] getRemoteFiles() {
        String[] files = new String[]{ACETYLATION, DISEASE_ASSOC, METHYLATION, PHOSPHORYLATION, REGULATORY, SUMOYLATION, UBIQUITINATION};
        return files;
    }

    public File[] getLocalFiles() {
        String[] rfiles = this.getRemoteFiles();
        File dir = this.getLocalDir();
        ArrayList<File> files = new ArrayList<File>();
        for (String f : rfiles) {
            int slashIndex = f.lastIndexOf("/");
            String fileName = f.substring(slashIndex);
            File localFile = new File(dir + "/" + fileName);
            if (!localFile.exists()) continue;
            files.add(localFile);
        }
        return files.toArray(new File[files.size()]);
    }

    public File getLocalDir() {
        AtomCache cache = new AtomCache();
        String path = cache.getCachePath();
        File dir = new File(path + "/phosphosite");
        return dir;
    }

    public void download() {
        String[] files;
        System.out.println("Downloading data from www.phosposite.org. Data is under CC-BY-NC-SA license. Please link to site and cite: ");
        System.out.println("Hornbeck PV, Kornhauser JM, Tkachev S, Zhang B, Skrzypek E, Murray B, Latham V, Sullivan M (2012) PhosphoSitePlus: a comprehensive resource for investigating the structure and function of experimentally determined post-translational modifications in man and mouse. Nucleic Acids Res. 40(Database issue), D261\u201370.");
        File dir = this.getLocalDir();
        if (!dir.exists()) {
            dir.mkdir();
        }
        for (String f : files = this.getRemoteFiles()) {
            try {
                int slashIndex = f.lastIndexOf("/");
                String fileName = f.substring(slashIndex);
                File localFile = new File(dir + "/" + fileName);
                if (localFile.exists()) continue;
                URL u = new URL(f);
                this.downloadFile(u, localFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void downloadFile(URL u, File localFile) throws IOException {
        System.out.println("Downloading " + u);
        File tmp = File.createTempFile("tmp", "phosphosite");
        InputStream is = u.openStream();
        BufferedInputStream in = new BufferedInputStream(is);
        FileOutputStream w = new FileOutputStream(tmp);
        int i = 0;
        byte[] bytesIn = new byte[300000];
        while ((i = in.read(bytesIn)) >= 0) {
            w.write(bytesIn, 0, i);
        }
        in.close();
        w.close();
        Dataset.copyFile(tmp, localFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) throws IOException {
        long p = 0L;
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            long dp;
            if (!dst.exists()) {
                dst.createNewFile();
            }
            in = new FileInputStream(src).getChannel();
            out = new FileOutputStream(dst).getChannel();
            long size = in.size();
            while ((dp = ((FileChannel)out).transferFrom(in, p, size)) > 0L) {
                p += dp;
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    public static void main(String[] args) {
        Dataset ds = new Dataset();
        ds.download();
        try {
            for (File f : ds.getLocalFiles()) {
                System.out.println(f.getAbsoluteFile());
                List<Site> sites = Site.parseSites(f);
                for (Site s : sites) {
                    if (!s.getUniprot().equals("P50225") && !s.getUniprot().equals("P48025")) continue;
                    System.out.println(s);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

