/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.protmod.structure;

import org.biojava.nbio.structure.ResidueNumber;

public class StructureGroup
implements Comparable<StructureGroup> {
    private ResidueNumber resNum;
    private String pdbName;
    private Boolean isAminoAcid;

    public StructureGroup() {
        this.resNum = new ResidueNumber();
    }

    public StructureGroup(ResidueNumber resNum, String pdbName, boolean isAminoAcid) {
        this.resNum = resNum;
        this.pdbName = pdbName;
        this.isAminoAcid = isAminoAcid;
    }

    public ResidueNumber getPDBResidueNumber() {
        return this.resNum;
    }

    public void setPDBResidueNumber(ResidueNumber resNum) {
        this.resNum = resNum;
    }

    public String getChainId() {
        return this.resNum.getChainId();
    }

    public void setChainId(String chainId) {
        if (this.resNum == null) {
            this.resNum = new ResidueNumber();
        }
        this.resNum.setChainId(chainId);
    }

    public int getResidueNumber() {
        return this.resNum.getSeqNum();
    }

    public void setResidueNumber(int seqNr) {
        if (this.resNum == null) {
            this.resNum = new ResidueNumber();
        }
        this.resNum.setSeqNum(Integer.valueOf(seqNr));
    }

    public Character getInsCode() {
        return this.resNum.getInsCode();
    }

    public void setInsCode(Character c) {
        if (this.resNum == null) {
            this.resNum = new ResidueNumber();
        }
        this.resNum.setInsCode(c);
    }

    public String getPDBName() {
        return this.pdbName;
    }

    public void setPDBName(String pdbName) {
        this.pdbName = pdbName;
    }

    public void setIsAminoAcid(boolean isAminoAcid) {
        this.isAminoAcid = isAminoAcid;
    }

    public boolean isAminoAcid() {
        return this.isAminoAcid;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StructureGroup)) {
            return false;
        }
        StructureGroup aGroup = (StructureGroup)obj;
        return this.resNum.equals((Object)aGroup.resNum);
    }

    public int hashCode() {
        int result = 17;
        if (this.resNum != null) {
            result = result * 31 + this.resNum.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pdbName);
        sb.append('\t');
        sb.append(this.resNum.getChainId());
        sb.append('\t');
        sb.append(this.resNum.getSeqNum());
        if (this.resNum.getInsCode() != null) {
            sb.append(this.resNum.getInsCode());
        }
        sb.append('\t');
        return sb.toString();
    }

    @Override
    public int compareTo(StructureGroup aGroup) {
        int result = this.getChainId().compareTo(aGroup.getChainId());
        if (result != 0) {
            return result;
        }
        result = this.getResidueNumber() - aGroup.getResidueNumber();
        if (result != 0) {
            return result;
        }
        if (this.getInsCode() == null) {
            if (aGroup.getInsCode() != null) {
                return -1;
            }
        } else {
            if (aGroup.getInsCode() == null) {
                return 1;
            }
            result = this.getInsCode().compareTo(aGroup.getInsCode());
            if (result != 0) {
                return result;
            }
        }
        return 0;
    }
}

