/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.protmod.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.biojava.nbio.protmod.structure.StructureAtom;
import org.biojava.nbio.protmod.structure.StructureAtomLinkage;
import org.biojava.nbio.protmod.structure.StructureGroup;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.ResidueNumber;

public final class StructureUtil {
    private StructureUtil() {
        throw new AssertionError();
    }

    public static StructureGroup getStructureGroup(Group group, boolean isAminoAcid) {
        ResidueNumber resNum = group.getResidueNumber();
        return new StructureGroup(resNum, group.getPDBName(), isAminoAcid);
    }

    public static StructureAtom getStructureAtom(Atom atom, boolean isParentAminoAcid) {
        StructureGroup strucGroup = StructureUtil.getStructureGroup(atom.getGroup(), isParentAminoAcid);
        return new StructureAtom(strucGroup, atom.getName());
    }

    public static StructureAtomLinkage getStructureAtomLinkage(Atom atom1, boolean isParentAminoAcid1, Atom atom2, boolean isParentAminoAcid2) {
        StructureAtom strucAtom1 = StructureUtil.getStructureAtom(atom1, isParentAminoAcid1);
        StructureAtom strucAtom2 = StructureUtil.getStructureAtom(atom2, isParentAminoAcid2);
        double distance = StructureUtil.getAtomDistance(atom1, atom2);
        return new StructureAtomLinkage(strucAtom1, strucAtom2, distance);
    }

    public static double getAtomDistance(Atom atom1, Atom atom2) {
        double distance = Calc.getDistance((Atom)atom1, (Atom)atom2);
        return distance;
    }

    public static Atom[] findNearestAtomLinkage(Group group1, Group group2, List<String> potentialNamesOfAtomOnGroup1, List<String> potentialNamesOfAtomOnGroup2, boolean ignoreNCLinkage, double bondLengthTolerance) {
        List<Atom[]> linkages = StructureUtil.findAtomLinkages(group1, group2, potentialNamesOfAtomOnGroup1, potentialNamesOfAtomOnGroup2, ignoreNCLinkage, bondLengthTolerance);
        Atom[] ret = null;
        double minDistance = Double.POSITIVE_INFINITY;
        for (Atom[] linkage : linkages) {
            double distance = Calc.getDistance((Atom)linkage[0], (Atom)linkage[1]);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            ret = linkage;
        }
        return ret;
    }

    public static List<Atom[]> findAtomLinkages(Group group1, Group group2, boolean ignoreNCLinkage, double bondLengthTolerance) {
        return StructureUtil.findAtomLinkages(group1, group2, null, null, ignoreNCLinkage, bondLengthTolerance);
    }

    public static List<Atom[]> findAtomLinkages(Group group1, Group group2, List<String> potentialNamesOfAtomOnGroup1, List<String> potentialNamesOfAtomOnGroup2, boolean ignoreNCLinkage, double bondLengthTolerance) {
        if (group1 == null || group2 == null) {
            throw new IllegalArgumentException("Null group(s).");
        }
        if (bondLengthTolerance < 0.0) {
            throw new IllegalArgumentException("bondLengthTolerance cannot be negative.");
        }
        ArrayList<Atom[]> ret = new ArrayList<Atom[]>();
        if (potentialNamesOfAtomOnGroup1 == null) {
            potentialNamesOfAtomOnGroup1 = StructureUtil.getAtomNames(group1);
        }
        if (potentialNamesOfAtomOnGroup2 == null) {
            potentialNamesOfAtomOnGroup2 = StructureUtil.getAtomNames(group2);
        }
        for (String namesOfAtomOnGroup1 : potentialNamesOfAtomOnGroup1) {
            for (String namesOfAtomOnGroup2 : potentialNamesOfAtomOnGroup2) {
                Atom[] atoms = StructureUtil.findLinkage(group1, group2, namesOfAtomOnGroup1, namesOfAtomOnGroup2, bondLengthTolerance);
                if (atoms == null || ignoreNCLinkage && (atoms[0].getName().equals("N") && atoms[1].getName().equals("C") || atoms[0].getName().equals("C") && atoms[1].getName().equals("N"))) continue;
                ret.add(atoms);
            }
        }
        return ret;
    }

    public static Atom[] findLinkage(Group group1, Group group2, String nameOfAtomOnGroup1, String nameOfAtomOnGroup2, double bondLengthTolerance) {
        float radiusOfAtom2;
        float radiusOfAtom1;
        Atom[] ret = new Atom[]{group1.getAtom(nameOfAtomOnGroup1), group2.getAtom(nameOfAtomOnGroup2)};
        if (ret[0] == null || ret[1] == null) {
            return null;
        }
        double distance = Calc.getDistance((Atom)ret[0], (Atom)ret[1]);
        if (Math.abs(distance - (double)(radiusOfAtom1 = ret[0].getElement().getCovalentRadius()) - (double)(radiusOfAtom2 = ret[1].getElement().getCovalentRadius())) > bondLengthTolerance) {
            return null;
        }
        return ret;
    }

    public static List<String> getAtomNames(Group group) {
        List atoms = group.getAtoms();
        if (atoms == null) {
            return Collections.emptyList();
        }
        int n = atoms.size();
        ArrayList<String> ret = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            ret.add(((Atom)atoms.get(i)).getName());
        }
        return ret;
    }

    public static List<Group> getAminoAcids(Chain chain) {
        return chain.getAtomGroups(GroupType.AMINOACID);
    }
}

