/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.protmod;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.biojava.nbio.protmod.Component;
import org.biojava.nbio.protmod.ModificationCondition;
import org.biojava.nbio.protmod.ModificationLinkage;

public class ModificationConditionImpl
implements ModificationCondition {
    private final List<Component> components;
    private final List<ModificationLinkage> linkages;

    public ModificationConditionImpl(List<Component> components, List<ModificationLinkage> linkages) {
        if (components == null) {
            throw new IllegalArgumentException("Can not create ModificationCondition, components == null!");
        }
        if (components.isEmpty()) {
            throw new IllegalArgumentException("Can not create ModificationCondition, components is empty!");
        }
        if (components.size() > 1) {
            HashSet<Integer> indices = new HashSet<Integer>();
            for (ModificationLinkage linkage : linkages) {
                indices.add(linkage.getIndexOfComponent1());
                indices.add(linkage.getIndexOfComponent2());
            }
            if (indices.size() != components.size()) {
                throw new IllegalStateException("All components have to be linked. indices.size:" + indices.size() + " components size:" + components.size());
            }
        }
        this.components = Collections.unmodifiableList(components);
        this.linkages = linkages == null ? Collections.emptyList() : Collections.unmodifiableList(linkages);
    }

    @Override
    public List<Component> getComponents() {
        return this.components;
    }

    @Override
    public List<ModificationLinkage> getLinkages() {
        return this.linkages;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Components:");
        for (Component comp : this.components) {
            sb.append(comp).append(";");
        }
        sb.deleteCharAt(sb.length() - 1);
        if (!this.linkages.isEmpty()) {
            sb.append("\nLinkages:");
            for (ModificationLinkage link : this.linkages) {
                sb.append(link).append(";");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

