/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.protmod.structure;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.nbio.protmod.ModificationCategory;
import org.biojava.nbio.protmod.ProteinModification;
import org.biojava.nbio.protmod.ProteinModificationImpl;
import org.biojava.nbio.protmod.io.ModifiedCompoundXMLConverter;
import org.biojava.nbio.protmod.structure.ModifiedCompound;
import org.biojava.nbio.protmod.structure.StructureAtomLinkage;
import org.biojava.nbio.protmod.structure.StructureGroup;

public class ModifiedCompoundImpl
implements ModifiedCompound,
Serializable,
Comparable<ModifiedCompound> {
    private static final long serialVersionUID = 1656563037849815427L;
    ProteinModification originalModification;
    ProteinModification modification;
    Set<StructureGroup> groups;
    Map<Set<StructureGroup>, Set<StructureAtomLinkage>> atomLinkages;
    public static final String newline = System.getProperty("line.separator");

    public ModifiedCompoundImpl() {
    }

    public ModifiedCompoundImpl(ProteinModification modification, StructureGroup modifiedResidue) {
        if (modification == null || modifiedResidue == null) {
            throw new IllegalArgumentException("Null argument(s)");
        }
        this.groups = new HashSet<StructureGroup>(1);
        this.groups.add(modifiedResidue);
        this.atomLinkages = null;
        this.setModification(modification);
    }

    public ModifiedCompoundImpl(ProteinModification modification, Collection<StructureAtomLinkage> linkages) {
        if (modification == null) {
            throw new IllegalArgumentException("modification cannot be null");
        }
        if (linkages == null || linkages.isEmpty()) {
            throw new IllegalArgumentException("at least one linkage.");
        }
        this.groups = new HashSet<StructureGroup>();
        this.addAtomLinkages(linkages);
        this.setModification(modification);
    }

    @Override
    public void setModification(ProteinModification protmod) {
        this.originalModification = protmod;
        this.resetModification();
    }

    @Override
    public ProteinModification getModification() {
        return this.modification;
    }

    private void resetModification() {
        if (this.originalModification == null) {
            this.modification = this.originalModification;
        } else if (this.originalModification.getCategory() != ModificationCategory.UNDEFINED) {
            this.modification = this.originalModification;
        } else {
            ModificationCategory cat;
            int nRes = 0;
            HashSet<String> ligands = new HashSet<String>();
            for (StructureGroup group : this.groups) {
                if (group.isAminoAcid()) {
                    ++nRes;
                    continue;
                }
                ligands.add(group.getPDBName().trim());
            }
            switch (nRes) {
                case 0: {
                    this.modification = this.originalModification;
                    return;
                }
                case 1: {
                    cat = ModificationCategory.ATTACHMENT;
                    break;
                }
                case 2: {
                    cat = ModificationCategory.CROSS_LINK_2;
                    break;
                }
                case 3: {
                    cat = ModificationCategory.CROSS_LINK_3;
                    break;
                }
                case 4: {
                    cat = ModificationCategory.CROSS_LINK_4;
                    break;
                }
                case 5: {
                    cat = ModificationCategory.CROSS_LINK_5;
                    break;
                }
                case 6: {
                    cat = ModificationCategory.CROSS_LINK_6;
                    break;
                }
                case 7: {
                    cat = ModificationCategory.CROSS_LINK_7;
                    break;
                }
                default: {
                    cat = ModificationCategory.CROSS_LINK_8_OR_LARGE;
                }
            }
            this.modification = new ProteinModificationImpl.Builder(this.originalModification).setCategory(cat).addKeywords(ligands).build();
        }
    }

    @Override
    public Set<StructureGroup> getGroups() {
        if (this.groups == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.groups);
    }

    @Override
    public Set<StructureGroup> getGroups(boolean isAminoAcid) {
        HashSet<StructureGroup> result = new HashSet<StructureGroup>();
        for (StructureGroup group : this.groups) {
            if (group.isAminoAcid() != isAminoAcid) continue;
            result.add(group);
        }
        return result;
    }

    @Override
    public void setGroups(Set<StructureGroup> groups) {
        this.groups = groups;
        this.resetModification();
    }

    @Override
    public Set<StructureAtomLinkage> getAtomLinkages() {
        if (this.atomLinkages == null) {
            return Collections.emptySet();
        }
        HashSet<StructureAtomLinkage> result = new HashSet<StructureAtomLinkage>();
        for (Set<StructureAtomLinkage> linkages : this.atomLinkages.values()) {
            result.addAll(linkages);
        }
        return result;
    }

    @Override
    public void setAtomLinkages(Set<StructureAtomLinkage> linkages) {
        for (StructureAtomLinkage sali : linkages) {
            this.addAtomLinkage(sali);
        }
        this.resetModification();
    }

    @Override
    public boolean addAtomLinkage(StructureAtomLinkage linkage) {
        Set<StructureAtomLinkage> linkages;
        if (linkage == null) {
            throw new IllegalArgumentException("Null linkage");
        }
        HashSet<StructureGroup> gs = new HashSet<StructureGroup>(2);
        gs.add(linkage.getAtom1().getGroup());
        gs.add(linkage.getAtom2().getGroup());
        if (this.atomLinkages == null) {
            this.atomLinkages = new HashMap<Set<StructureGroup>, Set<StructureAtomLinkage>>();
        }
        if ((linkages = this.atomLinkages.get(gs)) == null) {
            linkages = new HashSet<StructureAtomLinkage>();
            this.atomLinkages.put(gs, linkages);
            this.groups.addAll(gs);
        }
        return linkages.add(linkage);
    }

    @Override
    public void addAtomLinkages(Collection<StructureAtomLinkage> linkages) {
        if (linkages == null) {
            throw new IllegalArgumentException("Null linkages");
        }
        for (StructureAtomLinkage link : linkages) {
            this.addAtomLinkage(link);
        }
        this.resetModification();
    }

    @Override
    public boolean crossChains() {
        if (this.groups == null || this.groups.isEmpty()) {
            return false;
        }
        Iterator<StructureGroup> it = this.groups.iterator();
        String chain = it.next().getChainId();
        while (it.hasNext()) {
            if (it.next().getChainId().equals(chain)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.originalModification == null) {
            return "ModifiedCompoundImpl -- not initialized";
        }
        sb.append(this.originalModification.getId());
        ModificationCategory cat = this.originalModification.getCategory() == ModificationCategory.UNDEFINED ? this.getModification().getCategory() : this.originalModification.getCategory();
        sb.append("_");
        sb.append(cat.toString());
        return sb.toString();
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        if (this.getModification() == null) {
            sb.append(" !!! not initialized !!!");
            return sb.toString();
        }
        sb.append(this.originalModification.toString());
        return sb.toString();
    }

    @Override
    public void setDescription(String desc) {
    }

    @Override
    public int compareTo(ModifiedCompound compound) {
        try {
            String xml = ModifiedCompoundXMLConverter.toXML(this);
            String xml2 = ModifiedCompoundXMLConverter.toXML(compound);
            return xml.compareTo(xml2);
        }
        catch (Exception exception) {
            return this.toString().compareTo(compound.toString());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModifiedCompound)) {
            return false;
        }
        ModifiedCompound mci = (ModifiedCompound)obj;
        if (mci.getModification() != this.originalModification) {
            return false;
        }
        return this.groups.equals(mci.getGroups());
    }

    public int hashCode() {
        int result = 17;
        result = result * 32 + this.originalModification.hashCode();
        int sum = 0;
        for (StructureGroup group : this.groups) {
            sum += group.hashCode();
        }
        result = result * 32 + sum;
        return result;
    }
}

