/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.protmod;

import java.io.InputStream;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.nbio.protmod.Component;
import org.biojava.nbio.protmod.ModificationCategory;
import org.biojava.nbio.protmod.ModificationCondition;
import org.biojava.nbio.protmod.ModificationOccurrenceType;
import org.biojava.nbio.protmod.ProteinModification;
import org.biojava.nbio.protmod.io.ProteinModificationXmlReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProteinModificationRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ProteinModificationRegistry.class);
    private static Set<ProteinModification> registry = null;
    private static Map<String, ProteinModification> byId = null;
    private static Map<String, Set<ProteinModification>> byResidId = null;
    private static Map<String, Set<ProteinModification>> byPsimodId = null;
    private static Map<String, Set<ProteinModification>> byPdbccId = null;
    private static Map<String, Set<ProteinModification>> byKeyword = null;
    private static Map<Component, Set<ProteinModification>> byComponent = null;
    private static Map<ModificationCategory, Set<ProteinModification>> byCategory = null;
    private static Map<ModificationOccurrenceType, Set<ProteinModification>> byOccurrenceType = null;
    private static String DIR_XML_PTM_LIST = "ptm_list.xml";

    private static void registerCommonProteinModifications(InputStream inStream) {
        try {
            ProteinModificationXmlReader.registerProteinModificationFromXml(inStream);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
    }

    public static void init() {
        ProteinModificationRegistry.lazyInit();
    }

    public static void init(InputStream inStream) {
        ProteinModificationRegistry.lazyInit(inStream);
    }

    private static synchronized void lazyInit() {
        if (registry == null) {
            InputStream isXml = ProteinModification.class.getResourceAsStream(DIR_XML_PTM_LIST);
            ProteinModificationRegistry.lazyInit(isXml);
        }
    }

    private static synchronized void lazyInit(InputStream inStream) {
        if (registry == null) {
            registry = new HashSet<ProteinModification>();
            byId = new HashMap<String, ProteinModification>();
            byResidId = new HashMap<String, Set<ProteinModification>>();
            byPsimodId = new HashMap<String, Set<ProteinModification>>();
            byPdbccId = new HashMap<String, Set<ProteinModification>>();
            byKeyword = new HashMap<String, Set<ProteinModification>>();
            byComponent = new HashMap<Component, Set<ProteinModification>>();
            byCategory = new EnumMap<ModificationCategory, Set<ProteinModification>>(ModificationCategory.class);
            for (ModificationCategory modificationCategory : ModificationCategory.values()) {
                byCategory.put(modificationCategory, new HashSet());
            }
            byOccurrenceType = new EnumMap<ModificationOccurrenceType, Set<ProteinModification>>(ModificationOccurrenceType.class);
            for (Enum enum_ : ModificationOccurrenceType.values()) {
                byOccurrenceType.put((ModificationOccurrenceType)enum_, new HashSet());
            }
            ProteinModificationRegistry.registerCommonProteinModifications(inStream);
        }
    }

    public static void register(ProteinModification modification) {
        String psimodId;
        String residId;
        Set<ProteinModification> mods;
        if (modification == null) {
            throw new IllegalArgumentException("modification == null!");
        }
        ProteinModificationRegistry.lazyInit();
        String id = modification.getId();
        if (byId.containsKey(id)) {
            throw new IllegalArgumentException(id + " has already been registered.");
        }
        registry.add(modification);
        byId.put(id, modification);
        ModificationCategory cat = modification.getCategory();
        byCategory.get((Object)cat).add(modification);
        ModificationOccurrenceType occType = modification.getOccurrenceType();
        byOccurrenceType.get((Object)occType).add(modification);
        ModificationCondition condition = modification.getCondition();
        List<Component> comps = condition.getComponents();
        for (Component comp : comps) {
            mods = byComponent.get(comp);
            if (mods == null) {
                mods = new HashSet<ProteinModification>();
                byComponent.put(comp, mods);
            }
            mods.add(modification);
        }
        String pdbccId = modification.getPdbccId();
        if (pdbccId != null) {
            Set<ProteinModification> mods2 = byPdbccId.get(pdbccId);
            if (mods2 == null) {
                mods2 = new HashSet<ProteinModification>();
                byPdbccId.put(pdbccId, mods2);
            }
            mods2.add(modification);
        }
        if ((residId = modification.getResidId()) != null) {
            mods = byResidId.get(residId);
            if (mods == null) {
                mods = new HashSet<ProteinModification>();
                byResidId.put(residId, mods);
            }
            mods.add(modification);
        }
        if ((psimodId = modification.getPsimodId()) != null) {
            Set<ProteinModification> mods3 = byPsimodId.get(psimodId);
            if (mods3 == null) {
                mods3 = new HashSet<ProteinModification>();
                byPsimodId.put(psimodId, mods3);
            }
            mods3.add(modification);
        }
        for (String keyword : modification.getKeywords()) {
            Set<ProteinModification> mods4 = byKeyword.get(keyword);
            if (mods4 == null) {
                mods4 = new HashSet<ProteinModification>();
                byKeyword.put(keyword, mods4);
            }
            mods4.add(modification);
        }
    }

    public static void unregister(ProteinModification modification) {
        if (modification == null) {
            throw new IllegalArgumentException("modification == null!");
        }
        registry.remove(modification);
        byId.remove(modification.getId());
        Set<ProteinModification> mods = byResidId.get(modification.getResidId());
        if (mods != null) {
            mods.remove(modification);
        }
        if ((mods = byPsimodId.get(modification.getPsimodId())) != null) {
            mods.remove(modification);
        }
        if ((mods = byPdbccId.get(modification.getPdbccId())) != null) {
            mods.remove(modification);
        }
        for (String keyword : modification.getKeywords()) {
            mods = byKeyword.get(keyword);
            if (mods == null) continue;
            mods.remove(modification);
        }
        ModificationCondition condition = modification.getCondition();
        List<Component> comps = condition.getComponents();
        for (Component comp : comps) {
            mods = byComponent.get(comp);
            if (mods == null) continue;
            mods.remove(modification);
        }
        byCategory.get((Object)modification.getCategory()).remove(modification);
        byOccurrenceType.get((Object)modification.getOccurrenceType()).remove(modification);
    }

    public static ProteinModification getById(String id) {
        ProteinModificationRegistry.lazyInit();
        return byId.get(id);
    }

    public static Set<ProteinModification> getByResidId(String residId) {
        ProteinModificationRegistry.lazyInit();
        return byResidId.get(residId);
    }

    public static Set<ProteinModification> getByPsimodId(String psimodId) {
        ProteinModificationRegistry.lazyInit();
        return byPsimodId.get(psimodId);
    }

    public static Set<ProteinModification> getByPdbccId(String pdbccId) {
        ProteinModificationRegistry.lazyInit();
        return byPdbccId.get(pdbccId);
    }

    public static Set<ProteinModification> getByKeyword(String keyword) {
        ProteinModificationRegistry.lazyInit();
        return byKeyword.get(keyword);
    }

    public static Set<ProteinModification> getByComponent(Component comp1, Component ... comps) {
        ProteinModificationRegistry.lazyInit();
        Set<ProteinModification> mods = byComponent.get(comp1);
        if (mods == null) {
            return Collections.emptySet();
        }
        if (comps.length == 0) {
            return Collections.unmodifiableSet(mods);
        }
        HashSet<ProteinModification> ret = new HashSet<ProteinModification>(mods);
        for (Component comp : comps) {
            mods = byComponent.get(comp);
            if (mods == null) {
                return Collections.emptySet();
            }
            ret.retainAll(mods);
        }
        return ret;
    }

    public static Set<ProteinModification> allModifications() {
        ProteinModificationRegistry.lazyInit();
        return Collections.unmodifiableSet(registry);
    }

    public static Set<ProteinModification> getByCategory(ModificationCategory cat) {
        ProteinModificationRegistry.lazyInit();
        Set<ProteinModification> ret = byCategory.get((Object)cat);
        return Collections.unmodifiableSet(ret);
    }

    public static Set<ProteinModification> getByOccurrenceType(ModificationOccurrenceType occ) {
        ProteinModificationRegistry.lazyInit();
        Set<ProteinModification> ret = byOccurrenceType.get((Object)occ);
        return Collections.unmodifiableSet(ret);
    }

    public static Set<String> allIds() {
        ProteinModificationRegistry.lazyInit();
        Set<String> ret = byId.keySet();
        return Collections.unmodifiableSet(ret);
    }

    public static Set<String> allPdbccIds() {
        ProteinModificationRegistry.lazyInit();
        Set<String> ret = byPdbccId.keySet();
        return Collections.unmodifiableSet(ret);
    }

    public static Set<String> allResidIds() {
        ProteinModificationRegistry.lazyInit();
        Set<String> ret = byResidId.keySet();
        return Collections.unmodifiableSet(ret);
    }

    public static Set<String> allPsimodIds() {
        ProteinModificationRegistry.lazyInit();
        Set<String> ret = byPsimodId.keySet();
        return Collections.unmodifiableSet(ret);
    }

    public static Set<Component> allComponents() {
        ProteinModificationRegistry.lazyInit();
        Set<Component> ret = byComponent.keySet();
        return Collections.unmodifiableSet(ret);
    }

    public static Set<String> allKeywords() {
        ProteinModificationRegistry.lazyInit();
        Set<String> ret = byKeyword.keySet();
        return Collections.unmodifiableSet(ret);
    }
}

