/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.protmod;

import java.util.HashMap;
import java.util.Map;

public enum ModificationCategory {
    ATTACHMENT("attachment", "Attachment of a chemical group"),
    CHEMICAL_MODIFICATION("modified residue", "Chemical modification of an residue"),
    CROSS_LINK_1("crosslink1", "A complicated cross-link (usually found in chromophores)"),
    CROSS_LINK_2("crosslink2", "A cross-link of two residues"),
    CROSS_LINK_3("crosslink3", "A cross-link of three residues"),
    CROSS_LINK_4("crosslink4", "A cross-link of four residues"),
    CROSS_LINK_5("crosslink5", "A cross-link of five residues"),
    CROSS_LINK_6("crosslink6", "A cross-link of six residues"),
    CROSS_LINK_7("crosslink7", "A cross-link of seven residues"),
    CROSS_LINK_8_OR_LARGE("crosslink8 or large", "A cross-link of eight or more residues"),
    UNDEFINED("undefined", "Undefined category");

    private String label;
    private String desc;
    private static Map<String, ModificationCategory> mapLabelCat;

    private ModificationCategory(String label, String desc) {
        this.label = label;
    }

    public String label() {
        return this.label;
    }

    public String description() {
        return this.desc;
    }

    public String toString() {
        return this.label;
    }

    public boolean isCrossLink() {
        return this == CROSS_LINK_1 || this == CROSS_LINK_2 || this == CROSS_LINK_3 || this == CROSS_LINK_4 || this == CROSS_LINK_5 || this == CROSS_LINK_6 || this == CROSS_LINK_7 || this == CROSS_LINK_8_OR_LARGE;
    }

    public static ModificationCategory getByLabel(String label) {
        return mapLabelCat.get(label);
    }

    static {
        mapLabelCat = new HashMap<String, ModificationCategory>();
        for (ModificationCategory cat : ModificationCategory.values()) {
            mapLabelCat.put(cat.label, cat);
        }
    }
}

