/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.protmod.io;

import java.io.IOException;
import org.biojava.nbio.core.util.PrettyXMLWriter;
import org.biojava.nbio.protmod.structure.StructureGroup;
import org.biojava.nbio.structure.ResidueNumber;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StructureGroupXMLConverter {
    public static void toXML(StructureGroup group, PrettyXMLWriter xml) throws IOException {
        xml.openTag("structureGroup");
        xml.attribute("chainID", group.getChainId());
        xml.attribute("pdbName", group.getPDBName());
        if (group.getInsCode() != null) {
            xml.attribute("insCode", "" + group.getInsCode());
        }
        xml.attribute("residueNr", "" + group.getResidueNumber());
        xml.attribute("isAminoAcid", Boolean.toString(group.isAminoAcid()));
        xml.closeTag("structureGroup");
    }

    public static StructureGroup fromXML(Node n) {
        String chainID = StructureGroupXMLConverter.getAttribute(n, "chainID");
        String pdbName = StructureGroupXMLConverter.getAttribute(n, "pdbName");
        String insCode = StructureGroupXMLConverter.getAttribute(n, "insCode");
        String resN = StructureGroupXMLConverter.getAttribute(n, "residueNr");
        String isAminoAcid = StructureGroupXMLConverter.getAttribute(n, "isAminoAcid");
        ResidueNumber resNum = new ResidueNumber();
        resNum.setChainName(chainID);
        if (insCode != null && !insCode.equals("null") && insCode.length() == 1) {
            resNum.setInsCode(Character.valueOf(insCode.charAt(0)));
        }
        resNum.setSeqNum(Integer.valueOf(Integer.parseInt(resN)));
        StructureGroup g = new StructureGroup(resNum, pdbName, Boolean.valueOf(isAminoAcid));
        return g;
    }

    private static String getAttribute(Node node, String attr) {
        if (!node.hasAttributes()) {
            return null;
        }
        NamedNodeMap atts = node.getAttributes();
        if (atts == null) {
            return null;
        }
        Node att = atts.getNamedItem(attr);
        if (att == null) {
            return null;
        }
        String value = att.getTextContent();
        return value;
    }
}

