/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.protmod;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.biojava.nbio.protmod.ModificationCategory;
import org.biojava.nbio.protmod.ModificationCondition;
import org.biojava.nbio.protmod.ModificationOccurrenceType;
import org.biojava.nbio.protmod.ProteinModification;

public class ProteinModificationImpl
implements ProteinModification,
Comparable<ProteinModification> {
    private final String id;
    private final ModificationCondition condition;
    private final ModificationCategory category;
    private final ModificationOccurrenceType occurrenceType;
    private final String pdbccId;
    private final String pdbccName;
    private final String residId;
    private final String residName;
    private final String psimodId;
    private final String psimodName;
    private final String sysName;
    private final String formula;
    private final Set<String> keywords;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getPdbccId() {
        return this.pdbccId;
    }

    @Override
    public String getPdbccName() {
        return this.pdbccName;
    }

    @Override
    public String getResidId() {
        return this.residId;
    }

    @Override
    public String getResidName() {
        return this.residName;
    }

    @Override
    public String getPsimodId() {
        return this.psimodId;
    }

    @Override
    public String getPsimodName() {
        return this.psimodName;
    }

    @Override
    public String getSystematicName() {
        return this.sysName;
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    @Override
    public Set<String> getKeywords() {
        return this.keywords;
    }

    @Override
    public ModificationCondition getCondition() {
        return this.condition;
    }

    @Override
    public String getFormula() {
        return this.formula;
    }

    @Override
    public ModificationCategory getCategory() {
        return this.category;
    }

    @Override
    public ModificationOccurrenceType getOccurrenceType() {
        return this.occurrenceType;
    }

    public String toString() {
        return "ProteinModificationImpl [id=" + this.id + ", condition=" + this.condition + ", category=" + this.category + ", occurrenceType=" + this.occurrenceType + ", pdbccId=" + this.pdbccId + ", pdbccName=" + this.pdbccName + ", residId=" + this.residId + ", residName=" + this.residName + ", psimodId=" + this.psimodId + ", psimodName=" + this.psimodName + ", sysName=" + this.sysName + ", formula=" + this.formula + ", keywords=" + this.keywords + "]";
    }

    public int hashCode() {
        int ret = this.id.hashCode();
        ret = ret * 31 + this.category.hashCode();
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProteinModification)) {
            return false;
        }
        ProteinModification mod = (ProteinModification)obj;
        if (!this.id.equals(mod.getId())) {
            return false;
        }
        return this.category == mod.getCategory();
    }

    private ProteinModificationImpl(Builder builder) {
        this.id = builder.id;
        this.category = builder.category;
        this.occurrenceType = builder.occurrenceType;
        this.condition = builder.condition;
        this.pdbccId = builder.pdbccId;
        this.pdbccName = builder.pdbccName;
        this.residId = builder.residId;
        this.residName = builder.residName;
        this.psimodId = builder.psimodId;
        this.psimodName = builder.psimodName;
        this.sysName = builder.sysName;
        this.formula = builder.formula;
        this.keywords = new LinkedHashSet<String>(builder.keywords);
    }

    @Override
    public int compareTo(ProteinModification arg0) {
        if (this.equals(arg0)) {
            return 0;
        }
        return this.toString().compareTo(arg0.toString());
    }

    public static class Builder {
        private final String id;
        private ModificationCondition condition;
        private ModificationCategory category;
        private ModificationOccurrenceType occurrenceType;
        private String pdbccId = null;
        private String pdbccName = null;
        private String residId = null;
        private String residName = null;
        private String psimodId = null;
        private String psimodName = null;
        private String sysName = null;
        private String formula = null;
        private Set<String> keywords = new LinkedHashSet<String>();

        public Builder(String id, ModificationCategory cat, ModificationOccurrenceType occType, ModificationCondition condition) {
            if (id == null) {
                throw new IllegalArgumentException("id == null!");
            }
            if (cat == null) {
                throw new IllegalArgumentException("cat == null!");
            }
            if (occType == null) {
                throw new IllegalArgumentException("occType == null!");
            }
            if (condition == null) {
                throw new IllegalArgumentException("condition == null!");
            }
            this.id = id;
            this.category = cat;
            this.occurrenceType = occType;
            this.condition = condition;
        }

        public Builder(ProteinModification copyFrom) {
            this(copyFrom.getId(), copyFrom.getCategory(), copyFrom.getOccurrenceType(), copyFrom.getCondition());
            this.pdbccId = copyFrom.getPdbccId();
            this.pdbccName = copyFrom.getPdbccName();
            this.residId = copyFrom.getResidId();
            this.residName = copyFrom.getResidName();
            this.psimodId = copyFrom.getPsimodId();
            this.psimodName = copyFrom.getPsimodName();
            this.sysName = copyFrom.getSystematicName();
            this.formula = copyFrom.getFormula();
            this.keywords = new LinkedHashSet<String>(copyFrom.getKeywords());
        }

        public Builder setCategory(ModificationCategory cat) {
            if (cat == null) {
                throw new IllegalArgumentException("cat == null!");
            }
            this.category = cat;
            return this;
        }

        public Builder setOccurrenceType(ModificationOccurrenceType occType) {
            if (occType == null) {
                throw new IllegalArgumentException("occType == null!");
            }
            this.occurrenceType = occType;
            return this;
        }

        public Builder setCondition(ModificationCondition condition) {
            if (condition == null) {
                throw new IllegalArgumentException("condition == null!");
            }
            this.condition = condition;
            return this;
        }

        public Builder setPdbccId(String pdbccId) {
            this.pdbccId = pdbccId;
            return this;
        }

        public Builder setPdbccName(String pdbccName) {
            this.pdbccName = pdbccName;
            return this;
        }

        public Builder setResidId(String residId) {
            this.residId = residId;
            return this;
        }

        public Builder setResidName(String residName) {
            this.residName = residName;
            return this;
        }

        public Builder setPsimodId(String psimodId) {
            this.psimodId = psimodId;
            return this;
        }

        public Builder setPsimodName(String psimodName) {
            this.psimodName = psimodName;
            return this;
        }

        public Builder setSystematicName(String sysName) {
            this.sysName = sysName;
            return this;
        }

        public Builder setDescription(String description) {
            return this;
        }

        public Builder addKeyword(String keyword) {
            if (keyword == null) {
                throw new IllegalArgumentException("Keyword cannot be null.");
            }
            this.keywords.add(keyword);
            return this;
        }

        public Builder addKeywords(Collection<String> keywords) {
            if (keywords == null) {
                throw new IllegalArgumentException("Keywords cannot be null.");
            }
            for (String keyword : keywords) {
                this.addKeyword(keyword);
            }
            return this;
        }

        public Builder setFormula(String formula) {
            this.formula = formula;
            return this;
        }

        public ProteinModificationImpl build() {
            return new ProteinModificationImpl(this);
        }
    }
}

