/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.protmod.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.biojava.nbio.core.util.PrettyXMLWriter;
import org.biojava.nbio.protmod.ProteinModification;
import org.biojava.nbio.protmod.ProteinModificationRegistry;
import org.biojava.nbio.protmod.io.StructureAtomXMLConverter;
import org.biojava.nbio.protmod.io.StructureGroupXMLConverter;
import org.biojava.nbio.protmod.structure.ModifiedCompound;
import org.biojava.nbio.protmod.structure.ModifiedCompoundImpl;
import org.biojava.nbio.protmod.structure.StructureAtom;
import org.biojava.nbio.protmod.structure.StructureAtomLinkage;
import org.biojava.nbio.protmod.structure.StructureGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ModifiedCompoundXMLConverter {
    private static final Logger logger = LoggerFactory.getLogger(ModifiedCompoundXMLConverter.class);

    public static String toXML(ModifiedCompound mc) throws IOException {
        Set<StructureAtomLinkage> linkages;
        if (mc == null) {
            logger.warn("ModifiedCompound == null! ");
            return "<modifiedCompound/>";
        }
        StringWriter out = new StringWriter();
        PrettyXMLWriter xml = new PrettyXMLWriter(new PrintWriter(out));
        ProteinModification protMod = mc.getModification();
        String modificationId = protMod == null ? null : protMod.getId();
        xml.openTag("modifiedCompound");
        if (modificationId != null) {
            xml.openTag("proteinModification");
            xml.attribute("id", modificationId);
            xml.closeTag("proteinModification");
        }
        if ((linkages = mc.getAtomLinkages()).size() > 0) {
            int pos = -1;
            for (StructureAtomLinkage link : linkages) {
                xml.openTag("linkage");
                xml.attribute("pos", String.valueOf(++pos));
                xml.attribute("total", String.valueOf(linkages.size()));
                StructureAtom atom1 = link.getAtom1();
                StructureAtom atom2 = link.getAtom2();
                double distance = link.getDistance();
                xml.attribute("distance", String.valueOf(distance));
                xml.openTag("atom1");
                StructureAtomXMLConverter.toXML(atom1, xml);
                xml.closeTag("atom1");
                xml.openTag("atom2");
                StructureAtomXMLConverter.toXML(atom2, xml);
                xml.closeTag("atom2");
                xml.closeTag("linkage");
            }
        } else {
            xml.openTag("linkage");
            xml.closeTag("linkage");
            Set<StructureGroup> groups = mc.getGroups();
            for (StructureGroup group : groups) {
                StructureGroupXMLConverter.toXML(group, xml);
            }
        }
        xml.closeTag("modifiedCompound");
        return out.toString();
    }

    public static ModifiedCompound fromXML(String xml) {
        ProteinModification modification = null;
        StructureAtomLinkage[] linkages = null;
        ArrayList<StructureGroup> structureGroups = new ArrayList<StructureGroup>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = factory.newDocumentBuilder();
            InputSource inStream = new InputSource();
            inStream.setCharacterStream(new StringReader(xml));
            Document doc = db.parse(inStream);
            doc.getDocumentElement().normalize();
            NodeList listOfmodifications = doc.getElementsByTagName("modifiedCompound");
            for (int modPos = 0; modPos < listOfmodifications.getLength(); ++modPos) {
                Node modificationElement = listOfmodifications.item(modPos);
                NodeList children = modificationElement.getChildNodes();
                int numChildren = children.getLength();
                for (int e = 0; e < numChildren; ++e) {
                    Node listOfConditions = children.item(e);
                    if (!listOfConditions.hasAttributes()) continue;
                    if (listOfConditions.getNodeName().equals("proteinModification")) {
                        String modId = ModifiedCompoundXMLConverter.getAttribute(listOfConditions, "id");
                        modification = ProteinModificationRegistry.getById(modId);
                        if (modification != null) continue;
                        logger.warn("Error: no modification information.");
                        continue;
                    }
                    if (listOfConditions.getNodeName().equals("linkage")) {
                        StructureAtomLinkage linkage;
                        double dist = Double.parseDouble(ModifiedCompoundXMLConverter.getAttribute(listOfConditions, "distance"));
                        int pos = Integer.parseInt(ModifiedCompoundXMLConverter.getAttribute(listOfConditions, "pos"));
                        int total = Integer.parseInt(ModifiedCompoundXMLConverter.getAttribute(listOfConditions, "total"));
                        if (linkages == null) {
                            linkages = new StructureAtomLinkage[total];
                        }
                        StructureAtom atom1 = ModifiedCompoundXMLConverter.getAtom("atom1", listOfConditions);
                        StructureAtom atom2 = ModifiedCompoundXMLConverter.getAtom("atom2", listOfConditions);
                        linkages[pos] = linkage = new StructureAtomLinkage(atom1, atom2, dist);
                        continue;
                    }
                    if (!listOfConditions.getNodeName().equals("structureGroup")) continue;
                    StructureGroup group = StructureGroupXMLConverter.fromXML(listOfConditions);
                    structureGroups.add(group);
                }
            }
        }
        catch (SAXParseException err) {
            logger.error("** Parsing error, line: {}, uri: {}", new Object[]{err.getLineNumber(), err.getSystemId(), err});
        }
        catch (SAXException e) {
            logger.error("Exception: ", (Throwable)e);
        }
        catch (Throwable t) {
            logger.error("Exception: ", t);
        }
        if (linkages != null) {
            List<StructureAtomLinkage> links = Arrays.asList(linkages);
            return new ModifiedCompoundImpl(modification, links);
        }
        if (structureGroups.size() == 1) {
            return new ModifiedCompoundImpl(modification, (StructureGroup)structureGroups.get(0));
        }
        return null;
    }

    private static StructureAtom getAtom(String elementName, Node n) {
        NodeList children = n.getChildNodes();
        int numChildren = children.getLength();
        StructureAtom atom = null;
        for (int e = 0; e < numChildren; ++e) {
            Node atoms = children.item(e);
            if (!atoms.getNodeName().equals(elementName)) continue;
            NodeList child2 = atoms.getChildNodes();
            int numAtoms = child2.getLength();
            for (int a = 0; a < numAtoms; ++a) {
                Node atomNode = child2.item(a);
                if (!atomNode.hasAttributes()) continue;
                atom = StructureAtomXMLConverter.fromXML(atomNode);
                return atom;
            }
        }
        return atom;
    }

    private static String getAttribute(Node node, String attr) {
        if (!node.hasAttributes()) {
            return null;
        }
        NamedNodeMap atts = node.getAttributes();
        if (atts == null) {
            return null;
        }
        Node att = atts.getNamedItem(attr);
        if (att == null) {
            return null;
        }
        String value = att.getTextContent();
        return value;
    }
}

