/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.protmod.structure;

import org.biojava.nbio.protmod.structure.StructureGroup;

public class StructureAtom {
    private final StructureGroup group;
    private final String atomName;

    public StructureAtom(StructureGroup group, String atomName) {
        if (group == null || atomName == null) {
            throw new IllegalArgumentException("Null argument(s).");
        }
        this.group = group;
        this.atomName = atomName;
    }

    public StructureGroup getGroup() {
        return this.group;
    }

    public String getAtomName() {
        return this.atomName;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StructureAtom)) {
            return false;
        }
        StructureAtom anAtom = (StructureAtom)obj;
        if (!anAtom.getGroup().equals(this.group)) {
            return false;
        }
        return anAtom.getAtomName().equals(this.atomName);
    }

    public int hashCode() {
        int result = 17;
        result = result * 32 + this.group.hashCode();
        result = result * 32 + this.atomName.hashCode();
        return result;
    }

    public String toString() {
        return this.group.toString() + "\t" + this.atomName;
    }
}

