/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.protmod.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.biojava.nbio.protmod.Component;
import org.biojava.nbio.protmod.ModificationCategory;
import org.biojava.nbio.protmod.ModificationConditionImpl;
import org.biojava.nbio.protmod.ModificationLinkage;
import org.biojava.nbio.protmod.ModificationOccurrenceType;
import org.biojava.nbio.protmod.ProteinModificationImpl;
import org.biojava.nbio.protmod.ProteinModificationRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ProteinModificationXmlReader {
    private ProteinModificationXmlReader() {
    }

    public static void registerProteinModificationFromXml(InputStream isXml) throws IOException, ParserConfigurationException, SAXException {
        if (isXml == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(isXml);
        NodeList modNodes = doc.getElementsByTagName("Entry");
        int modSize = modNodes.getLength();
        for (int iMod = 0; iMod < modSize; ++iMod) {
            Node modNode = modNodes.item(iMod);
            Map<String, List<Node>> infoNodes = ProteinModificationXmlReader.getChildNodes(modNode);
            List<Node> nodes = infoNodes.get("Id");
            if (nodes == null || nodes.size() != 1) {
                throw new RuntimeException("Each modification must have exact one <Id> field.");
            }
            String id = nodes.get(0).getTextContent();
            nodes = infoNodes.get("Category");
            if (nodes == null || nodes.size() != 1) {
                throw new RuntimeException("Each modification must have exact one <Category> field. See Modification " + id + ".");
            }
            ModificationCategory cat = ModificationCategory.getByLabel(nodes.get(0).getTextContent());
            if (cat == null) {
                throw new RuntimeException(nodes.get(0).getTextContent() + " is not defined as an modification category. See Modification " + id + ".");
            }
            nodes = infoNodes.get("Occurrence");
            if (nodes == null || nodes.size() != 1) {
                throw new RuntimeException("Each modification must have exact one <Occurrence> field. See Modification " + id + ".");
            }
            ModificationOccurrenceType occType = ModificationOccurrenceType.getByLabel(nodes.get(0).getTextContent());
            if (occType == null) {
                throw new RuntimeException(nodes.get(0).getTextContent() + " is not defined as an modification occurence type. See Modification " + id + ".");
            }
            ModificationConditionImpl condition = null;
            nodes = infoNodes.get("Condition");
            if (nodes == null || nodes.size() != 1) {
                throw new RuntimeException("Each modification must have exact one <Condition> field. See Modification " + id + ".");
            }
            Node compsNode = nodes.get(0);
            HashMap<String, Integer> mapLabelComp = new HashMap<String, Integer>();
            Map<String, List<Node>> compInfoNodes = ProteinModificationXmlReader.getChildNodes(compsNode);
            List<Node> compNodes = compInfoNodes.get("Component");
            int sizeComp = compNodes.size();
            ArrayList<Component> comps = new ArrayList<Component>(sizeComp);
            for (int iComp = 0; iComp < sizeComp; ++iComp) {
                Node compNode = compNodes.get(iComp);
                NamedNodeMap compNodeAttrs = compNode.getAttributes();
                Node labelNode = compNodeAttrs.getNamedItem("component");
                if (labelNode == null) {
                    throw new RuntimeException("Each component must have a label. See Modification " + id + ".");
                }
                String label = labelNode.getTextContent();
                if (mapLabelComp.containsKey(label)) {
                    throw new RuntimeException("Each component must have a unique label. See Modification " + id + ".");
                }
                HashSet<String> compIds = new HashSet<String>();
                List<Node> compIdNodes = ProteinModificationXmlReader.getChildNodes(compNode).get("Id");
                if (compIdNodes != null) {
                    for (Node compIdNode : compIdNodes) {
                        NamedNodeMap compIdNodeAttr = compIdNode.getAttributes();
                        Node compIdSource = compIdNodeAttr.getNamedItem("source");
                        if (compIdSource == null || !"PDBCC".equals(compIdSource.getTextContent())) continue;
                        String strComps = compIdNode.getTextContent();
                        if (strComps.isEmpty()) {
                            throw new RuntimeException("Empty component. See Modification " + id + ".");
                        }
                        compIds.addAll(Arrays.asList(strComps.split(",")));
                    }
                }
                if (compIds.isEmpty()) {
                    throw new RuntimeException("Each component must have a PDBCC ID. See Modification " + id + ".");
                }
                boolean nTerminal = false;
                boolean cTerminal = false;
                List<Node> compTermNode = ProteinModificationXmlReader.getChildNodes(compNode).get("Terminal");
                if (compTermNode != null) {
                    if (compTermNode.size() != 1) {
                        throw new RuntimeException("Only one <Terminal> condition is allowed for each component. See Modification " + id + ".");
                    }
                    String nc = compTermNode.get(0).getTextContent();
                    if ("N".equals(nc)) {
                        nTerminal = true;
                    } else if ("C".equals(nc)) {
                        cTerminal = true;
                    } else {
                        throw new RuntimeException("Only N or C is allowed for <Terminal>. See Modification " + id + ".");
                    }
                }
                Component comp = Component.of(compIds, nTerminal, cTerminal);
                comps.add(comp);
                mapLabelComp.put(label, comps.size() - 1);
            }
            List<Node> bondNodes = compInfoNodes.get("Bond");
            ArrayList<ModificationLinkage> linkages = null;
            if (bondNodes != null) {
                int sizeBonds = bondNodes.size();
                linkages = new ArrayList<ModificationLinkage>(sizeBonds);
                for (int iBond = 0; iBond < sizeBonds; ++iBond) {
                    Node bondNode = bondNodes.get(iBond);
                    Map<String, List<Node>> bondChildNodes = ProteinModificationXmlReader.getChildNodes(bondNode);
                    if (bondChildNodes == null) {
                        throw new RuntimeException("Each bond must contain two atoms See Modification " + id + ".");
                    }
                    List<Node> atomNodes = bondChildNodes.get("Atom");
                    if (atomNodes == null || atomNodes.size() != 2) {
                        throw new RuntimeException("Each bond must contain two atoms See Modification " + id + ".");
                    }
                    NamedNodeMap atomNodeAttrs = atomNodes.get(0).getAttributes();
                    Node compNode = atomNodeAttrs.getNamedItem("component");
                    if (compNode == null) {
                        throw new RuntimeException("Each atom must on a component. See Modification " + id + ".");
                    }
                    String labelComp1 = compNode.getTextContent();
                    int iComp1 = (Integer)mapLabelComp.get(labelComp1);
                    Node labelNode = atomNodeAttrs.getNamedItem("atom");
                    String labelAtom1 = labelNode == null ? null : labelNode.getTextContent();
                    String atom1 = atomNodes.get(0).getTextContent();
                    if (atom1.isEmpty()) {
                        throw new RuntimeException("Each atom must have a name. Please use wildcard * if unknown. See Modification " + id + ".");
                    }
                    List<String> potentialAtoms1 = Arrays.asList(atom1.split(","));
                    atomNodeAttrs = atomNodes.get(1).getAttributes();
                    compNode = atomNodeAttrs.getNamedItem("component");
                    if (compNode == null) {
                        throw new RuntimeException("Each atom must on a component. See Modification " + id + ".");
                    }
                    String labelComp2 = compNode.getTextContent();
                    int iComp2 = (Integer)mapLabelComp.get(labelComp2);
                    labelNode = atomNodeAttrs.getNamedItem("atom");
                    String labelAtom2 = labelNode == null ? null : labelNode.getTextContent();
                    String atom2 = atomNodes.get(1).getTextContent();
                    if (atom2.isEmpty()) {
                        throw new RuntimeException("Each atom must have a name. Please use wildcard * if unknown. See Modification " + id + ".");
                    }
                    List<String> potentialAtoms2 = Arrays.asList(atom2.split(","));
                    ModificationLinkage linkage = new ModificationLinkage(comps, iComp1, potentialAtoms1, labelAtom1, iComp2, potentialAtoms2, labelAtom2);
                    linkages.add(linkage);
                }
            }
            condition = new ModificationConditionImpl(comps, linkages);
            ProteinModificationImpl.Builder modBuilder = new ProteinModificationImpl.Builder(id, cat, occType, condition);
            nodes = infoNodes.get("Description");
            if (nodes != null && !nodes.isEmpty()) {
                modBuilder.setDescription(nodes.get(0).getTextContent());
            }
            if ((nodes = infoNodes.get("CrossReference")) != null) {
                for (Node node : nodes) {
                    Map<String, List<Node>> xrefInfoNodes = ProteinModificationXmlReader.getChildNodes(node);
                    List<Node> xrefNode = xrefInfoNodes.get("Source");
                    if (xrefNode == null || xrefNode.size() != 1) {
                        throw new RuntimeException("Error in XML file: a cross reference must contain exactly one <Source> field. See Modification " + id + ".");
                    }
                    String xrefDb = xrefNode.get(0).getTextContent();
                    xrefNode = xrefInfoNodes.get("Id");
                    if (xrefNode == null || xrefNode.size() != 1) {
                        throw new RuntimeException("Error in XML file: a cross reference must contain exactly one <Id> field. See Modification " + id + ".");
                    }
                    String xrefId = xrefNode.get(0).getTextContent();
                    String xrefName = null;
                    xrefNode = xrefInfoNodes.get("Name");
                    if (xrefNode != null && !xrefNode.isEmpty()) {
                        xrefName = xrefNode.get(0).getTextContent();
                    }
                    if ("PDBCC".equals(xrefDb)) {
                        modBuilder.setPdbccId(xrefId).setPdbccName(xrefName);
                        continue;
                    }
                    if ("RESID".equals(xrefDb)) {
                        modBuilder.setResidId(xrefId).setResidName(xrefName);
                        continue;
                    }
                    if (!"PSI-MOD".equals(xrefDb)) continue;
                    modBuilder.setPsimodId(xrefId).setPsimodName(xrefName);
                }
            }
            if ((nodes = infoNodes.get("Formula")) != null && !nodes.isEmpty()) {
                modBuilder.setFormula(nodes.get(0).getTextContent());
            }
            if ((nodes = infoNodes.get("Keyword")) != null && !nodes.isEmpty()) {
                for (Node node : nodes) {
                    modBuilder.addKeyword(node.getTextContent());
                }
            }
            ProteinModificationRegistry.register(modBuilder.build());
        }
    }

    private static Map<String, List<Node>> getChildNodes(Node parent) {
        if (parent == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Node>> children = new HashMap<String, List<Node>>();
        NodeList nodes = parent.getChildNodes();
        int nNodes = nodes.getLength();
        for (int i = 0; i < nNodes; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ArrayList<Node> namesakes = (ArrayList<Node>)children.get(name);
            if (namesakes == null) {
                namesakes = new ArrayList<Node>();
                children.put(name, namesakes);
            }
            namesakes.add(node);
        }
        return children;
    }
}

