/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.protmod.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.biojava.nbio.protmod.Component;
import org.biojava.nbio.protmod.ModificationCategory;
import org.biojava.nbio.protmod.ModificationCondition;
import org.biojava.nbio.protmod.ModificationLinkage;
import org.biojava.nbio.protmod.ProteinModification;
import org.biojava.nbio.protmod.ProteinModificationRegistry;
import org.biojava.nbio.protmod.structure.ModifiedCompound;
import org.biojava.nbio.protmod.structure.ModifiedCompoundImpl;
import org.biojava.nbio.protmod.structure.StructureAtomLinkage;
import org.biojava.nbio.protmod.structure.StructureGroup;
import org.biojava.nbio.protmod.structure.StructureUtil;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProteinModificationIdentifier {
    private static final Logger logger = LoggerFactory.getLogger(ProteinModificationIdentifier.class);
    private double bondLengthTolerance = 0.4;
    private boolean recordUnidentifiableModifiedCompounds = false;
    private boolean recordAdditionalAttachments = true;
    private Set<ModifiedCompound> identifiedModifiedCompounds = null;
    private Set<StructureAtomLinkage> unidentifiableAtomLinkages = null;
    private Set<StructureGroup> unidentifiableModifiedResidues = null;
    private List<Group> residues;

    public ProteinModificationIdentifier() {
        this.reset();
    }

    public void destroy() {
        if (this.identifiedModifiedCompounds != null) {
            this.identifiedModifiedCompounds.clear();
        }
        if (this.unidentifiableAtomLinkages != null) {
            this.unidentifiableAtomLinkages.clear();
        }
        if (this.unidentifiableModifiedResidues != null) {
            this.unidentifiableModifiedResidues.clear();
        }
        this.unidentifiableAtomLinkages = null;
        this.unidentifiableAtomLinkages = null;
        this.unidentifiableModifiedResidues = null;
    }

    public void setbondLengthTolerance(double bondLengthTolerance) {
        if (bondLengthTolerance < 0.0) {
            throw new IllegalArgumentException("bondLengthTolerance must be positive.");
        }
        this.bondLengthTolerance = bondLengthTolerance;
    }

    public void setRecordUnidentifiableCompounds(boolean recordUnidentifiableModifiedCompounds) {
        this.recordUnidentifiableModifiedCompounds = recordUnidentifiableModifiedCompounds;
    }

    public boolean getRecordUnidentifiableCompounds() {
        return this.recordUnidentifiableModifiedCompounds;
    }

    public void setRecordAdditionalAttachments(boolean recordAdditionalAttachments) {
        this.recordAdditionalAttachments = recordAdditionalAttachments;
    }

    public boolean getRecordAdditionalAttachments() {
        return this.recordAdditionalAttachments;
    }

    public Set<ModifiedCompound> getIdentifiedModifiedCompound() {
        if (this.identifiedModifiedCompounds == null) {
            throw new IllegalStateException("No result available. Please call parse() first.");
        }
        return this.identifiedModifiedCompounds;
    }

    public Set<StructureAtomLinkage> getUnidentifiableAtomLinkages() {
        if (!this.recordUnidentifiableModifiedCompounds) {
            throw new UnsupportedOperationException("Recording unidentified atom linkagesis not supported. Please setRecordUnidentifiableCompounds(true) first.");
        }
        if (this.identifiedModifiedCompounds == null) {
            throw new IllegalStateException("No result available. Please call parse() first.");
        }
        return this.unidentifiableAtomLinkages;
    }

    public Set<StructureGroup> getUnidentifiableModifiedResidues() {
        if (!this.recordUnidentifiableModifiedCompounds) {
            throw new UnsupportedOperationException("Recording unidentified atom linkagesis not supported. Please setRecordUnidentifiableCompounds(true) first.");
        }
        if (this.identifiedModifiedCompounds == null) {
            throw new IllegalStateException("No result available. Please call parse() first.");
        }
        return this.unidentifiableModifiedResidues;
    }

    public void identify(Structure structure) {
        this.identify(structure, ProteinModificationRegistry.allModifications());
    }

    public void identify(Structure structure, Set<ProteinModification> potentialModifications) {
        if (structure == null) {
            throw new IllegalArgumentException("Null structure.");
        }
        this.identify(structure.getChains(), potentialModifications);
    }

    public void identify(Chain chain) {
        this.identify(Collections.singletonList(chain));
    }

    public void identify(List<Chain> chains) {
        this.identify(chains, ProteinModificationRegistry.allModifications());
    }

    public void identify(Chain chain, Set<ProteinModification> potentialModifications) {
        this.identify(Collections.singletonList(chain), potentialModifications);
    }

    public void identify(List<Chain> chains, Set<ProteinModification> potentialModifications) {
        if (chains == null) {
            throw new IllegalArgumentException("Null structure.");
        }
        if (potentialModifications == null) {
            throw new IllegalArgumentException("Null potentialModifications.");
        }
        this.reset();
        if (potentialModifications.isEmpty()) {
            return;
        }
        this.residues = new ArrayList<Group>();
        ArrayList<Group> ligands = new ArrayList<Group>();
        HashMap<Component, Set<Group>> mapCompGroups = new HashMap<Component, Set<Group>>();
        for (Chain chain : chains) {
            List<Group> ress = StructureUtil.getAminoAcids(chain);
            List ligs = StructureTools.filterLigands((List)chain.getAtomGroups());
            this.residues.addAll(ress);
            this.residues.removeAll(ligs);
            ligands.addAll(ligs);
            this.addModificationGroups(potentialModifications, ress, ligs, mapCompGroups);
        }
        if (this.residues.isEmpty()) {
            Structure struc;
            String pdbId = "?";
            if (chains.size() > 0 && (struc = chains.get(0).getStructure()) != null) {
                pdbId = struc.getPDBCode();
            }
            logger.warn("No amino acids found for {}. Either you did not parse the PDB file with alignSEQRES records, or this record does not contain any amino acids.", (Object)pdbId);
        }
        ArrayList<ModifiedCompound> modComps = new ArrayList<ModifiedCompound>();
        for (ProteinModification mod : potentialModifications) {
            ModificationCondition condition = mod.getCondition();
            List<Component> components = condition.getComponents();
            if (!mapCompGroups.keySet().containsAll(components)) continue;
            int sizeComps = components.size();
            if (sizeComps == 1) {
                this.processCrosslink1(mapCompGroups, modComps, mod, components);
                continue;
            }
            this.processMultiCrosslink(mapCompGroups, modComps, mod, condition);
        }
        if (this.recordAdditionalAttachments) {
            for (ModifiedCompound mc : modComps) {
                this.identifyAdditionalAttachments(mc, ligands, chains);
            }
        }
        this.mergeModComps(modComps);
        this.identifiedModifiedCompounds.addAll(modComps);
        if (this.recordUnidentifiableModifiedCompounds) {
            this.recordUnidentifiableAtomLinkages(modComps, ligands);
            this.recordUnidentifiableModifiedResidues(modComps);
        }
    }

    private void reset() {
        this.identifiedModifiedCompounds = new LinkedHashSet<ModifiedCompound>();
        if (this.recordUnidentifiableModifiedCompounds) {
            this.unidentifiableAtomLinkages = new LinkedHashSet<StructureAtomLinkage>();
            this.unidentifiableModifiedResidues = new LinkedHashSet<StructureGroup>();
        }
    }

    private void processMultiCrosslink(Map<Component, Set<Group>> mapCompGroups, List<ModifiedCompound> modComps, ProteinModification mod, ModificationCondition condition) {
        List<List<Atom[]>> matchedAtomsOfLinkages = this.getMatchedAtomsOfLinkages(condition, mapCompGroups);
        if (matchedAtomsOfLinkages.size() != condition.getLinkages().size()) {
            return;
        }
        this.assembleLinkages(matchedAtomsOfLinkages, mod, modComps);
    }

    private void processCrosslink1(Map<Component, Set<Group>> mapCompGroups, List<ModifiedCompound> modComps, ProteinModification mod, List<Component> components) {
        Set<Group> modifiedResidues = mapCompGroups.get(components.get(0));
        if (modifiedResidues != null) {
            for (Group residue : modifiedResidues) {
                StructureGroup strucGroup = StructureUtil.getStructureGroup(residue, true);
                ModifiedCompoundImpl modRes = new ModifiedCompoundImpl(mod, strucGroup);
                modComps.add(modRes);
            }
        }
    }

    private void identifyAdditionalAttachments(ModifiedCompound mc, List<Group> ligands, List<Chain> chains) {
        if (ligands.isEmpty()) {
            return;
        }
        ArrayList<Group> identifiedGroups = new ArrayList<Group>();
        for (StructureGroup num : mc.getGroups(false)) {
            Group group;
            try {
                ResidueNumber resNum = new ResidueNumber();
                resNum.setChainName(num.getChainId());
                resNum.setSeqNum(Integer.valueOf(num.getResidueNumber()));
                resNum.setInsCode(num.getInsCode());
                group = this.getGroup(num, chains);
            }
            catch (StructureException e) {
                logger.error("Exception: ", (Throwable)e);
                continue;
            }
            identifiedGroups.add(group);
        }
        int start = 0;
        int n = identifiedGroups.size();
        while (n > start) {
            block4: for (Group group1 : ligands) {
                for (int i = start; i < n; ++i) {
                    List<Atom[]> linkedAtoms;
                    Group group2 = (Group)identifiedGroups.get(i);
                    if (identifiedGroups.contains(group1) || (linkedAtoms = StructureUtil.findAtomLinkages(group1, group2, false, this.bondLengthTolerance)).isEmpty()) continue;
                    for (Atom[] atoms : linkedAtoms) {
                        mc.addAtomLinkage(StructureUtil.getStructureAtomLinkage(atoms[0], false, atoms[1], false));
                    }
                    identifiedGroups.add(group1);
                    continue block4;
                }
            }
            start = n;
            n = identifiedGroups.size();
        }
    }

    private Group getGroup(StructureGroup num, List<Chain> chains) throws StructureException {
        for (Chain c : chains) {
            if (!c.getId().equals(num.getChainId())) continue;
            ResidueNumber resNum = new ResidueNumber();
            resNum.setSeqNum(Integer.valueOf(num.getResidueNumber()));
            resNum.setInsCode(num.getInsCode());
            return c.getGroupByPDB(resNum);
        }
        throw new StructureException("Could not find residue " + num);
    }

    private void mergeModComps(List<ModifiedCompound> modComps) {
        TreeSet<Integer> remove = new TreeSet<Integer>();
        int n = modComps.size();
        for (int icurr = 1; icurr < n; ++icurr) {
            ModifiedCompound mcKeep;
            ModifiedCompound pre;
            int ipre;
            ModifiedCompound curr = modComps.get(icurr);
            String id = curr.getModification().getId();
            if (ProteinModificationRegistry.getById(id).getCategory() != ModificationCategory.UNDEFINED) continue;
            for (ipre = 0; ipre < icurr && (remove.contains(ipre) || Collections.disjoint((pre = modComps.get(ipre)).getGroups(false), curr.getGroups(false))); ++ipre) {
            }
            if (ipre >= icurr || !(mcKeep = modComps.get(ipre)).getModification().getId().equals(id)) continue;
            mcKeep.addAtomLinkages(curr.getAtomLinkages());
            remove.add(icurr);
        }
        Iterator it = remove.descendingIterator();
        while (it.hasNext()) {
            modComps.remove((Integer)it.next());
        }
    }

    private void recordUnidentifiableAtomLinkages(List<ModifiedCompound> modComps, List<Group> ligands) {
        HashSet<StructureAtomLinkage> identifiedLinkages = new HashSet<StructureAtomLinkage>();
        for (ModifiedCompound mc : modComps) {
            identifiedLinkages.addAll(mc.getAtomLinkages());
        }
        int nRes = this.residues.size();
        for (int i = 0; i < nRes - 1; ++i) {
            Group group1 = this.residues.get(i);
            for (int j = i + 1; j < nRes; ++j) {
                Group group2 = this.residues.get(j);
                List<Atom[]> linkages = StructureUtil.findAtomLinkages(group1, group2, true, this.bondLengthTolerance);
                for (Atom[] atoms : linkages) {
                    StructureAtomLinkage link = StructureUtil.getStructureAtomLinkage(atoms[0], true, atoms[1], true);
                    this.unidentifiableAtomLinkages.add(link);
                }
            }
        }
        int nLig = ligands.size();
        for (int i = 0; i < nRes; ++i) {
            Group group1 = this.residues.get(i);
            for (int j = 0; j < nLig; ++j) {
                Group group2 = ligands.get(j);
                if (group1.equals(group2)) continue;
                List<Atom[]> linkages = StructureUtil.findAtomLinkages(group1, group2, false, this.bondLengthTolerance);
                for (Atom[] atoms : linkages) {
                    StructureAtomLinkage link = StructureUtil.getStructureAtomLinkage(atoms[0], true, atoms[1], false);
                    this.unidentifiableAtomLinkages.add(link);
                }
            }
        }
    }

    private void recordUnidentifiableModifiedResidues(List<ModifiedCompound> modComps) {
        HashSet<StructureGroup> identifiedComps = new HashSet<StructureGroup>();
        for (ModifiedCompound mc : modComps) {
            identifiedComps.addAll(mc.getGroups(true));
        }
        for (Group group : this.residues) {
            if (!group.getType().equals((Object)GroupType.HETATM)) continue;
            StructureGroup strucGroup = StructureUtil.getStructureGroup(group, true);
            strucGroup.setChainId(group.getChainId());
            if (identifiedComps.contains(strucGroup)) continue;
            this.unidentifiableModifiedResidues.add(strucGroup);
        }
    }

    private void addModificationGroups(Set<ProteinModification> modifications, List<Group> residues, List<Group> ligands, Map<Component, Set<Group>> saveTo) {
        Set<Group> gs;
        Set comps;
        Group res;
        String pdbccId;
        if (residues == null || ligands == null || modifications == null) {
            throw new IllegalArgumentException("Null argument(s).");
        }
        HashMap<Component, HashSet<Component>> mapSingleMultiComps = new HashMap<Component, HashSet<Component>>();
        for (ProteinModification proteinModification : modifications) {
            ModificationCondition condition = proteinModification.getCondition();
            for (Component comp : condition.getComponents()) {
                for (String pdbccId2 : comp.getPdbccIds()) {
                    Component single = Component.of(Collections.singleton(pdbccId2), comp.isNTerminal(), comp.isCTerminal());
                    HashSet<Component> mult = (HashSet<Component>)mapSingleMultiComps.get(single);
                    if (mult == null) {
                        mult = new HashSet<Component>();
                        mapSingleMultiComps.put(single, mult);
                    }
                    mult.add(comp);
                }
            }
        }
        Set ligandsWildCard = (Set)mapSingleMultiComps.get(Component.of("*"));
        for (Group group : ligands) {
            pdbccId = group.getPDBName().trim();
            Set comps2 = (Set)mapSingleMultiComps.get(Component.of(pdbccId));
            for (Component comp : this.unionComponentSet(ligandsWildCard, comps2)) {
                Set<Group> gs2 = saveTo.get(comp);
                if (gs2 == null) {
                    gs2 = new LinkedHashSet<Group>();
                    saveTo.put(comp, gs2);
                }
                gs2.add(group);
            }
        }
        if (residues.isEmpty()) {
            return;
        }
        Set residuesWildCard = (Set)mapSingleMultiComps.get(Component.of("*"));
        for (Group group : residues) {
            pdbccId = group.getPDBName().trim();
            Set comps2 = (Set)mapSingleMultiComps.get(Component.of(pdbccId));
            for (Component comp : this.unionComponentSet(residuesWildCard, comps2)) {
                Set<Group> gs2 = saveTo.get(comp);
                if (gs2 == null) {
                    gs2 = new LinkedHashSet<Group>();
                    saveTo.put(comp, gs2);
                }
                gs2.add(group);
            }
        }
        int n = residues.size();
        int iRes = 0;
        do {
            res = residues.get(iRes++);
            Set nTermWildCard = (Set)mapSingleMultiComps.get(Component.of("*", true, false));
            comps = (Set)mapSingleMultiComps.get(Component.of(res.getPDBName(), true, false));
            for (Component comp : this.unionComponentSet(nTermWildCard, comps)) {
                gs = saveTo.get(comp);
                if (gs == null) {
                    gs = new LinkedHashSet<Group>();
                    saveTo.put(comp, gs);
                }
                gs.add(res);
            }
        } while (iRes < n && ligands.contains(res));
        iRes = residues.size() - 1;
        do {
            res = residues.get(iRes--);
            Set cTermWildCard = (Set)mapSingleMultiComps.get(Component.of("*", false, true));
            comps = (Set)mapSingleMultiComps.get(Component.of(res.getPDBName(), false, true));
            for (Component comp : this.unionComponentSet(cTermWildCard, comps)) {
                gs = saveTo.get(comp);
                if (gs == null) {
                    gs = new LinkedHashSet<Group>();
                    saveTo.put(comp, gs);
                }
                gs.add(res);
            }
        } while (iRes >= 0 && ligands.contains(res));
    }

    private Set<Component> unionComponentSet(Set<Component> set1, Set<Component> set2) {
        if (set1 == null && set2 == null) {
            return Collections.emptySet();
        }
        if (set1 == null) {
            return set2;
        }
        if (set2 == null) {
            return set1;
        }
        HashSet<Component> set = new HashSet<Component>(set1.size() + set2.size());
        set.addAll(set1);
        set.addAll(set2);
        return set;
    }

    private List<List<Atom[]>> getMatchedAtomsOfLinkages(ModificationCondition condition, Map<Component, Set<Group>> mapCompGroups) {
        List<ModificationLinkage> linkages = condition.getLinkages();
        int nLink = linkages.size();
        ArrayList<List<Atom[]>> matchedAtomsOfLinkages = new ArrayList<List<Atom[]>>(nLink);
        for (int iLink = 0; iLink < nLink; ++iLink) {
            ModificationLinkage linkage = linkages.get(iLink);
            Component comp1 = linkage.getComponent1();
            Component comp2 = linkage.getComponent2();
            Set<Group> groups1 = mapCompGroups.get(comp1);
            Set<Group> groups2 = mapCompGroups.get(comp2);
            ArrayList<Atom[]> list = new ArrayList<Atom[]>();
            List<String> potentialNamesOfAtomOnGroup1 = linkage.getPDBNameOfPotentialAtomsOnComponent1();
            for (String name : potentialNamesOfAtomOnGroup1) {
                if (!"*".equals(name)) continue;
                potentialNamesOfAtomOnGroup1 = null;
                break;
            }
            List<String> potentialNamesOfAtomOnGroup2 = linkage.getPDBNameOfPotentialAtomsOnComponent2();
            for (String name : potentialNamesOfAtomOnGroup2) {
                if (!"*".equals(name)) continue;
                potentialNamesOfAtomOnGroup2 = null;
                break;
            }
            for (Group g1 : groups1) {
                for (Group g2 : groups2) {
                    boolean ignoreNCLinkage;
                    Atom[] atoms;
                    if (g1.equals(g2) || (atoms = StructureUtil.findNearestAtomLinkage(g1, g2, potentialNamesOfAtomOnGroup1, potentialNamesOfAtomOnGroup2, ignoreNCLinkage = potentialNamesOfAtomOnGroup1 == null && potentialNamesOfAtomOnGroup2 == null && this.residues.contains(g1) && this.residues.contains(g2), this.bondLengthTolerance)) == null) continue;
                    list.add(atoms);
                }
            }
            if (list.isEmpty()) break;
            matchedAtomsOfLinkages.add(list);
        }
        return matchedAtomsOfLinkages;
    }

    private void assembleLinkages(List<List<Atom[]>> matchedAtomsOfLinkages, ProteinModification mod, List<ModifiedCompound> ret) {
        ModificationCondition condition = mod.getCondition();
        List<ModificationLinkage> modLinks = condition.getLinkages();
        int nLink = matchedAtomsOfLinkages.size();
        int[] indices = new int[nLink];
        HashSet<ModifiedCompoundImpl> identifiedCompounds = new HashSet<ModifiedCompoundImpl>();
        block0: while (indices[0] < matchedAtomsOfLinkages.get(0).size()) {
            ArrayList<Atom[]> atomLinkages = new ArrayList<Atom[]>(nLink);
            for (int iLink = 0; iLink < nLink; ++iLink) {
                Atom[] atoms = matchedAtomsOfLinkages.get(iLink).get(indices[iLink]);
                atomLinkages.add(atoms);
            }
            if (this.matchLinkages(modLinks, atomLinkages)) {
                int n = atomLinkages.size();
                ArrayList<StructureAtomLinkage> linkages = new ArrayList<StructureAtomLinkage>(n);
                for (int i = 0; i < n; ++i) {
                    Atom[] linkage = (Atom[])atomLinkages.get(i);
                    StructureAtomLinkage link = StructureUtil.getStructureAtomLinkage(linkage[0], this.residues.contains(linkage[0].getGroup()), linkage[1], this.residues.contains(linkage[1].getGroup()));
                    linkages.add(link);
                }
                ModifiedCompoundImpl mc = new ModifiedCompoundImpl(mod, linkages);
                if (!identifiedCompounds.contains(mc)) {
                    ret.add(mc);
                    identifiedCompounds.add(mc);
                }
            }
            for (int i = nLink - 1; i >= 0; --i) {
                if (i == 0 || indices[i] < matchedAtomsOfLinkages.get(i).size() - 1) {
                    int n = i;
                    indices[n] = indices[n] + 1;
                    continue block0;
                }
                indices[i] = 0;
            }
        }
    }

    private boolean matchLinkages(List<ModificationLinkage> linkages, List<Atom[]> atomLinkages) {
        int nLink = linkages.size();
        if (nLink != atomLinkages.size()) {
            return false;
        }
        for (int i = 0; i < nLink - 1; ++i) {
            ModificationLinkage link1 = linkages.get(i);
            Atom[] atoms1 = atomLinkages.get(i);
            for (int j = i + 1; j < nLink; ++j) {
                ModificationLinkage link2 = linkages.get(j);
                Atom[] atoms2 = atomLinkages.get(j);
                if (link1.getIndexOfComponent1() == link2.getIndexOfComponent1() != atoms1[0].getGroup().equals(atoms2[0].getGroup()) || link1.getIndexOfComponent1() == link2.getIndexOfComponent2() != atoms1[0].getGroup().equals(atoms2[1].getGroup()) || link1.getIndexOfComponent2() == link2.getIndexOfComponent1() != atoms1[1].getGroup().equals(atoms2[0].getGroup()) || link1.getIndexOfComponent2() == link2.getIndexOfComponent2() != atoms1[1].getGroup().equals(atoms2[1].getGroup())) {
                    return false;
                }
                String label11 = link1.getLabelOfAtomOnComponent1();
                String label12 = link1.getLabelOfAtomOnComponent2();
                String label21 = link2.getLabelOfAtomOnComponent1();
                String label22 = link2.getLabelOfAtomOnComponent2();
                if ((label11 != null && label21 != null && label11.equals(label21)) == atoms1[0].equals(atoms2[0]) && (label11 != null && label22 != null && label11.equals(label22)) == atoms1[0].equals(atoms2[1]) && (label12 != null && label21 != null && label12.equals(label21)) == atoms1[1].equals(atoms2[0]) && (label12 != null && label22 != null && label12.equals(label22)) == atoms1[1].equals(atoms2[1])) continue;
                return false;
            }
        }
        return true;
    }
}

